/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.nio.charset.StandardCharsets;
import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.jgit.internal.JGitText;

public final class Base85 {
    private static final byte[] ENCODE = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz!#$%&()*+-;<=>?@^_`{|}~".getBytes(StandardCharsets.US_ASCII);
    private static final int[] DECODE = new int[256];

    static {
        Arrays.fill(DECODE, -1);
        int i2 = 0;
        while (i2 < ENCODE.length) {
            Base85.DECODE[Base85.ENCODE[i2]] = i2;
            ++i2;
        }
    }

    private Base85() {
    }

    public static int encodedLength(int rawLength) {
        return (rawLength + 3) / 4 * 5;
    }

    public static byte[] encode(byte[] data2) {
        return Base85.encode(data2, 0, data2.length);
    }

    public static byte[] encode(byte[] data2, int start2, int length) {
        byte[] result2 = new byte[Base85.encodedLength(length)];
        int end2 = start2 + length;
        int in = start2;
        int out2 = 0;
        while (in < end2) {
            long accumulator = (long)(data2[in++] & 0xFF) << 24;
            if (in < end2) {
                accumulator |= (long)((data2[in++] & 0xFF) << 16);
                if (in < end2) {
                    accumulator |= (long)((data2[in++] & 0xFF) << 8);
                    if (in < end2) {
                        accumulator |= (long)(data2[in++] & 0xFF);
                    }
                }
            }
            int i2 = 4;
            while (i2 >= 0) {
                result2[out2 + i2] = ENCODE[(int)(accumulator % 85L)];
                accumulator /= 85L;
                --i2;
            }
            out2 += 5;
        }
        return result2;
    }

    public static byte[] decode(byte[] encoded, int expectedSize) {
        return Base85.decode(encoded, 0, encoded.length, expectedSize);
    }

    public static byte[] decode(byte[] encoded, int start2, int length, int expectedSize) {
        if (length % 5 != 0) {
            throw new IllegalArgumentException(JGitText.get().base85length);
        }
        byte[] result2 = new byte[expectedSize];
        int end2 = start2 + length;
        int in = start2;
        int out2 = 0;
        while (in < end2 && out2 < expectedSize) {
            long accumulator = 0L;
            int i2 = 4;
            while (i2 >= 0) {
                int val;
                if ((val = DECODE[encoded[in++] & 0xFF]) < 0) {
                    throw new IllegalArgumentException(MessageFormat.format(JGitText.get().base85invalidChar, Integer.toHexString(encoded[in - 1] & 0xFF)));
                }
                accumulator = accumulator * 85L + (long)val;
                --i2;
            }
            if (accumulator > 0xFFFFFFFFL) {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().base85overflow, Long.toHexString(accumulator)));
            }
            result2[out2++] = (byte)(accumulator >>> 24);
            if (out2 >= expectedSize) continue;
            result2[out2++] = (byte)(accumulator >>> 16);
            if (out2 >= expectedSize) continue;
            result2[out2++] = (byte)(accumulator >>> 8);
            if (out2 >= expectedSize) continue;
            result2[out2++] = (byte)accumulator;
        }
        if (in < end2) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().base85tooLong, expectedSize));
        }
        if (out2 < expectedSize) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().base85tooShort, expectedSize));
        }
        return result2;
    }
}

