/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.File;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.jgit.api.errors.JGitInternalException;
import org.eclipse.jgit.errors.CommandFailedException;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.FS_Win32;
import org.eclipse.jgit.util.ProcessResult;
import org.eclipse.jgit.util.QuotedString;
import org.eclipse.jgit.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FS_Win32_Cygwin
extends FS_Win32 {
    private static final Logger LOG = LoggerFactory.getLogger(FS_Win32_Cygwin.class);
    private static String cygpath;

    public static boolean isCygwin() {
        String path2 = System.getProperty("java.library.path");
        if (path2 == null) {
            return false;
        }
        File found = FS.searchPath(path2, "cygpath.exe");
        if (found != null) {
            cygpath = found.getPath();
        }
        return cygpath != null;
    }

    public FS_Win32_Cygwin() {
    }

    protected FS_Win32_Cygwin(FS src) {
        super(src);
    }

    @Override
    public FS newInstance() {
        return new FS_Win32_Cygwin(this);
    }

    @Override
    public File resolve(File dir, String pn) {
        String useCygPath = System.getProperty("jgit.usecygpath");
        if (useCygPath != null && useCygPath.equals("true")) {
            String w;
            try {
                w = FS_Win32_Cygwin.readPipe(dir, new String[]{cygpath, "--windows", "--absolute", pn}, StandardCharsets.UTF_8.name());
            }
            catch (CommandFailedException e2) {
                LOG.warn(e2.getMessage());
                return null;
            }
            if (!StringUtils.isEmptyOrNull(w)) {
                return new File(w);
            }
        }
        return super.resolve(dir, pn);
    }

    @Override
    protected File userHomeImpl() {
        String home = System.getenv("HOME");
        if (home == null || home.length() == 0) {
            return super.userHomeImpl();
        }
        return this.resolve(new File("."), home);
    }

    @Override
    public ProcessBuilder runInShell(String cmd, String[] args2) {
        ArrayList<String> argv = new ArrayList<String>(4 + args2.length);
        argv.add("sh.exe");
        argv.add("-c");
        argv.add(cmd + " \"$@\"");
        argv.add(cmd);
        argv.addAll(Arrays.asList(args2));
        ProcessBuilder proc = new ProcessBuilder(new String[0]);
        proc.command(argv);
        return proc;
    }

    @Override
    String shellQuote(String cmd) {
        return QuotedString.BOURNE.quote(cmd.replace(File.separatorChar, '/'));
    }

    @Override
    public String relativize(String base, String other) {
        String relativized = super.relativize(base, other);
        return relativized.replace(File.separatorChar, '/');
    }

    @Override
    public ProcessResult runHookIfPresent(Repository repository, String hookName, String[] args2, OutputStream outRedirect, OutputStream errRedirect, String stdinArgs) throws JGitInternalException {
        return this.internalRunHookIfPresent(repository, hookName, args2, outRedirect, errRedirect, stdinArgs);
    }
}

