/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;

public final class Hex {
    private static final char[] HEX = "0123456789abcdef".toCharArray();

    private Hex() {
    }

    public static byte[] decode(String s2) {
        int len2 = s2.length();
        byte[] b2 = new byte[len2 / 2];
        int i2 = 0;
        while (i2 < len2) {
            int left = Character.digit(s2.charAt(i2), 16);
            int right = Character.digit(s2.charAt(i2 + 1), 16);
            if (left == -1 || right == -1) {
                throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidHexString, s2));
            }
            b2[i2 / 2] = (byte)(left << 4 | right);
            i2 += 2;
        }
        return b2;
    }

    public static String toHexString(byte[] b2) {
        char[] c2 = new char[b2.length * 2];
        int i2 = 0;
        while (i2 < b2.length) {
            int v = b2[i2] & 0xFF;
            c2[i2 * 2] = HEX[v >>> 4];
            c2[i2 * 2 + 1] = HEX[v & 0xF];
            ++i2;
        }
        return new String(c2);
    }
}

