/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.EOFException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.io.SilentFileInputStream;

public class IO {
    public static final byte[] readFully(File path2) throws FileNotFoundException, IOException {
        return IO.readFully(path2, Integer.MAX_VALUE);
    }

    public static final byte[] readSome(File path2, int limit) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (SilentFileInputStream in = new SilentFileInputStream(path2);){
            return in.readNBytes(limit);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static final byte[] readFully(File path2, int max2) throws FileNotFoundException, IOException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (SilentFileInputStream in = new SilentFileInputStream(path2);){
            byte[] buf = in.readNBytes(max2);
            if (in.read() != -1) {
                throw new IOException(MessageFormat.format(JGitText.get().fileIsTooLarge, path2));
            }
            return buf;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static ByteBuffer readWholeStream(InputStream in, int sizeHint) throws IOException {
        return ByteBuffer.wrap(in.readAllBytes());
    }

    public static void readFully(InputStream fd, byte[] dst, int off, int len2) throws IOException {
        int read2 = fd.readNBytes(dst, off, len2);
        if (read2 != len2) {
            throw new EOFException(JGitText.get().shortReadOfBlock);
        }
    }

    public static void readFully(InputStream fd, byte[] dst) throws IOException {
        IO.readFully(fd, dst, 0, dst.length);
    }

    public static int read(ReadableByteChannel channel2, byte[] dst, int off, int len2) throws IOException {
        if (len2 == 0) {
            return 0;
        }
        int cnt = 0;
        while (len2 > 0) {
            int r = channel2.read(ByteBuffer.wrap(dst, off, len2));
            if (r <= 0) break;
            off += r;
            len2 -= r;
            cnt += r;
        }
        return cnt != 0 ? cnt : -1;
    }

    public static int readFully(InputStream fd, byte[] dst, int off) throws IOException {
        return fd.readNBytes(dst, off, dst.length - off);
    }

    public static void skipFully(InputStream fd, long toSkip) throws IOException {
        while (toSkip > 0L) {
            long r = fd.skip(toSkip);
            if (r <= 0L) {
                throw new EOFException(JGitText.get().shortSkipOfBlock);
            }
            toSkip -= r;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static List<String> readLines(String s2) {
        ArrayList<String> l = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        int i2 = 0;
        while (i2 < s2.length()) {
            block5: {
                char c2;
                block6: {
                    block4: {
                        c2 = s2.charAt(i2);
                        if (c2 != '\n') break block4;
                        l.add(sb.toString());
                        sb.setLength(0);
                        break block5;
                    }
                    if (c2 != '\r') break block6;
                    if (i2 + 1 < s2.length()) {
                        c2 = s2.charAt(++i2);
                        l.add(sb.toString());
                        sb.setLength(0);
                        if (c2 != '\n') {
                            sb.append(c2);
                        }
                        break block5;
                    } else {
                        l.add(sb.toString());
                        break;
                    }
                }
                sb.append(c2);
            }
            ++i2;
        }
        l.add(sb.toString());
        return l;
    }

    public static String readLine(Reader in, int sizeHint) throws IOException {
        int i2;
        if (in.markSupported()) {
            if (sizeHint <= 0) {
                sizeHint = 1024;
            }
            StringBuilder sb = new StringBuilder(sizeHint);
            char[] buf = new char[sizeHint];
            while (true) {
                in.mark(sizeHint);
                int n = in.read(buf);
                if (n < 0) {
                    in.reset();
                    return sb.toString();
                }
                int i3 = 0;
                while (i3 < n) {
                    if (buf[i3] == '\n') {
                        IO.resetAndSkipFully(in, ++i3);
                        sb.append(buf, 0, i3);
                        return sb.toString();
                    }
                    ++i3;
                }
                if (n > 0) {
                    sb.append(buf, 0, n);
                }
                IO.resetAndSkipFully(in, n);
            }
        }
        StringBuilder buf = sizeHint > 0 ? new StringBuilder(sizeHint) : new StringBuilder();
        while ((i2 = in.read()) != -1) {
            char c2 = (char)i2;
            buf.append(c2);
            if (c2 == '\n') break;
        }
        return buf.toString();
    }

    private static void resetAndSkipFully(Reader fd, long toSkip) throws IOException {
        fd.reset();
        while (toSkip > 0L) {
            long r = fd.skip(toSkip);
            if (r <= 0L) {
                throw new EOFException(JGitText.get().shortSkipOfBlock);
            }
            toSkip -= r;
        }
    }

    private IO() {
    }
}

