/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.IOException;
import java.lang.management.ManagementFactory;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectInstance;
import javax.management.ObjectName;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.util.SystemReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Monitoring {
    private static final Logger LOG = LoggerFactory.getLogger(Monitoring.class);

    @Nullable
    public static ObjectInstance registerMBean(Object mbean, String metricName) {
        boolean register2 = false;
        try {
            Class<?>[] interfaces;
            Class<?>[] classArray = interfaces = mbean.getClass().getInterfaces();
            int n = interfaces.length;
            int n2 = 0;
            while (n2 < n) {
                Class<?> i2 = classArray[n2];
                register2 = SystemReader.getInstance().getUserConfig().getBoolean("jmx", i2.getSimpleName(), false);
                if (!register2) {
                    ++n2;
                    continue;
                }
                break;
            }
        }
        catch (IOException | ConfigInvalidException e2) {
            LOG.error(e2.getMessage(), e2);
            return null;
        }
        if (!register2) {
            return null;
        }
        MBeanServer server2 = ManagementFactory.getPlatformMBeanServer();
        try {
            ObjectName mbeanName = Monitoring.objectName(mbean.getClass(), metricName);
            if (server2.isRegistered(mbeanName)) {
                server2.unregisterMBean(mbeanName);
            }
            return server2.registerMBean(mbean, mbeanName);
        }
        catch (InstanceAlreadyExistsException | InstanceNotFoundException | MBeanRegistrationException | MalformedObjectNameException | NotCompliantMBeanException e3) {
            LOG.error(e3.getMessage(), e3);
            return null;
        }
    }

    private static ObjectName objectName(Class mbean, String metricName) throws MalformedObjectNameException {
        return new ObjectName(String.format("org.eclipse.jgit/%s:type=%s", metricName, mbean.getSimpleName()));
    }
}

