/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.nio.ByteBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.StandardCharsets;
import java.nio.charset.UnsupportedCharsetException;
import java.time.DateTimeException;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.diff.RawText;
import org.eclipse.jgit.errors.BinaryBlobException;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.lib.ObjectChecker;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.util.IntList;
import org.eclipse.jgit.util.MutableInteger;
import org.eclipse.jgit.util.StringUtils;
import org.eclipse.jgit.util.SystemReader;

public final class RawParseUtils {
    private static final byte[] digits10;
    private static final byte[] digits16;
    private static final byte[] footerLineKeyChars;
    private static final Map<String, Charset> encodingAliases;
    private static final byte[] base10byte;

    static {
        encodingAliases = new HashMap<String, Charset>();
        encodingAliases.put("latin-1", StandardCharsets.ISO_8859_1);
        encodingAliases.put("iso-latin-1", StandardCharsets.ISO_8859_1);
        digits10 = new byte[58];
        Arrays.fill(digits10, (byte)-1);
        int i2 = 48;
        while (i2 <= 57) {
            RawParseUtils.digits10[i2] = (byte)(i2 - 48);
            i2 = (char)(i2 + 1);
        }
        digits16 = new byte[103];
        Arrays.fill(digits16, (byte)-1);
        i2 = 48;
        while (i2 <= 57) {
            RawParseUtils.digits16[i2] = (byte)(i2 - 48);
            i2 = (char)(i2 + 1);
        }
        i2 = 97;
        while (i2 <= 102) {
            RawParseUtils.digits16[i2] = (byte)(i2 - 97 + 10);
            i2 = (char)(i2 + 1);
        }
        i2 = 65;
        while (i2 <= 70) {
            RawParseUtils.digits16[i2] = (byte)(i2 - 65 + 10);
            i2 = (char)(i2 + 1);
        }
        footerLineKeyChars = new byte[123];
        RawParseUtils.footerLineKeyChars[45] = 1;
        i2 = 48;
        while (i2 <= 57) {
            RawParseUtils.footerLineKeyChars[i2] = 1;
            i2 = (char)(i2 + 1);
        }
        i2 = 65;
        while (i2 <= 90) {
            RawParseUtils.footerLineKeyChars[i2] = 1;
            i2 = (char)(i2 + 1);
        }
        i2 = 97;
        while (i2 <= 122) {
            RawParseUtils.footerLineKeyChars[i2] = 1;
            i2 = (char)(i2 + 1);
        }
        base10byte = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57};
    }

    public static final int match(byte[] b2, int ptr, byte[] src) {
        if (ptr + src.length > b2.length) {
            return -1;
        }
        int i2 = 0;
        while (i2 < src.length) {
            if (b2[ptr] != src[i2]) {
                return -1;
            }
            ++i2;
            ++ptr;
        }
        return ptr;
    }

    public static int formatBase10(byte[] b2, int o, int value2) {
        boolean isneg;
        if (value2 == 0) {
            b2[--o] = 48;
            return o;
        }
        boolean bl = isneg = value2 < 0;
        if (isneg) {
            value2 = -value2;
        }
        while (value2 != 0) {
            b2[--o] = base10byte[value2 % 10];
            value2 /= 10;
        }
        if (isneg) {
            b2[--o] = 45;
        }
        return o;
    }

    public static final int parseBase10(byte[] b2, int ptr, MutableInteger ptrResult) {
        int sz;
        int sign;
        int r;
        block11: {
            r = 0;
            sign = 0;
            sz = b2.length;
            while (ptr < sz && b2[ptr] == 32) {
                ++ptr;
            }
            if (ptr < sz) break block11;
            return 0;
        }
        try {
            switch (b2[ptr]) {
                case 45: {
                    sign = -1;
                    ++ptr;
                    break;
                }
                case 43: {
                    ++ptr;
                }
            }
            while (ptr < sz) {
                byte v = digits10[b2[ptr]];
                if (v >= 0) {
                    r = r * 10 + v;
                    ++ptr;
                    continue;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (ptrResult != null) {
            ptrResult.value = ptr;
        }
        return sign < 0 ? -r : r;
    }

    public static final long parseLongBase10(byte[] b2, int ptr, MutableInteger ptrResult) {
        int sz;
        int sign;
        long r;
        block11: {
            r = 0L;
            sign = 0;
            sz = b2.length;
            while (ptr < sz && b2[ptr] == 32) {
                ++ptr;
            }
            if (ptr < sz) break block11;
            return 0L;
        }
        try {
            switch (b2[ptr]) {
                case 45: {
                    sign = -1;
                    ++ptr;
                    break;
                }
                case 43: {
                    ++ptr;
                }
            }
            while (ptr < sz) {
                byte v = digits10[b2[ptr]];
                if (v >= 0) {
                    r = r * 10L + (long)v;
                    ++ptr;
                    continue;
                }
                break;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
        if (ptrResult != null) {
            ptrResult.value = ptr;
        }
        return sign < 0 ? -r : r;
    }

    public static final int parseHexInt16(byte[] bs, int p) {
        int r = digits16[bs[p]] << 4;
        r |= digits16[bs[p + 1]];
        r <<= 4;
        r |= digits16[bs[p + 2]];
        r <<= 4;
        if ((r |= digits16[bs[p + 3]]) < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return r;
    }

    public static final int parseHexInt32(byte[] bs, int p) {
        int r = digits16[bs[p]] << 4;
        r |= digits16[bs[p + 1]];
        r <<= 4;
        r |= digits16[bs[p + 2]];
        r <<= 4;
        r |= digits16[bs[p + 3]];
        r <<= 4;
        r |= digits16[bs[p + 4]];
        r <<= 4;
        r |= digits16[bs[p + 5]];
        r <<= 4;
        byte last2 = digits16[bs[p + 7]];
        if ((r |= digits16[bs[p + 6]]) < 0 || last2 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return r << 4 | last2;
    }

    public static final long parseHexInt64(byte[] bs, int p) {
        long r = digits16[bs[p]] << 4;
        r |= (long)digits16[bs[p + 1]];
        r <<= 4;
        r |= (long)digits16[bs[p + 2]];
        r <<= 4;
        r |= (long)digits16[bs[p + 3]];
        r <<= 4;
        r |= (long)digits16[bs[p + 4]];
        r <<= 4;
        r |= (long)digits16[bs[p + 5]];
        r <<= 4;
        r |= (long)digits16[bs[p + 6]];
        r <<= 4;
        r |= (long)digits16[bs[p + 7]];
        r <<= 4;
        r |= (long)digits16[bs[p + 8]];
        r <<= 4;
        r |= (long)digits16[bs[p + 9]];
        r <<= 4;
        r |= (long)digits16[bs[p + 10]];
        r <<= 4;
        r |= (long)digits16[bs[p + 11]];
        r <<= 4;
        r |= (long)digits16[bs[p + 12]];
        r <<= 4;
        r |= (long)digits16[bs[p + 13]];
        r <<= 4;
        byte last2 = digits16[bs[p + 15]];
        if ((r |= (long)digits16[bs[p + 14]]) < 0L || last2 < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return r << 4 | (long)last2;
    }

    public static final int parseHexInt4(byte digit) {
        byte r = digits16[digit];
        if (r < 0) {
            throw new ArrayIndexOutOfBoundsException();
        }
        return r;
    }

    public static final int parseTimeZoneOffset(byte[] b2, int ptr) {
        return RawParseUtils.parseTimeZoneOffset(b2, ptr, null);
    }

    public static final int parseTimeZoneOffset(byte[] b2, int ptr, MutableInteger ptrResult) {
        int v = RawParseUtils.parseBase10(b2, ptr, ptrResult);
        int tzMins = v % 100;
        int tzHours = v / 100;
        return tzHours * 60 + tzMins;
    }

    private static ZoneId parseZoneOffset(byte[] b2, int ptr, MutableInteger ptrResult) {
        int hhmm = RawParseUtils.parseBase10(b2, ptr, ptrResult);
        try {
            return ZoneOffset.ofHoursMinutes(hhmm / 100, hhmm % 100);
        }
        catch (DateTimeException e2) {
            return ZoneOffset.UTC;
        }
    }

    public static final int next(byte[] b2, int ptr, char chrA) {
        int sz = b2.length;
        while (ptr < sz) {
            if (b2[ptr++] != chrA) continue;
            return ptr;
        }
        return ptr;
    }

    public static final int nextLF(byte[] b2, int ptr) {
        return RawParseUtils.next(b2, ptr, '\n');
    }

    public static final int nextLF(byte[] b2, int ptr, char chrA) {
        int sz = b2.length;
        while (ptr < sz) {
            byte c2;
            if ((c2 = b2[ptr++]) != chrA && c2 != 10) continue;
            return ptr;
        }
        return ptr;
    }

    public static final int nextLfSkippingSplitLines(byte[] b2, int ptr) {
        int sz = b2.length;
        while (ptr < sz) {
            byte c2;
            if ((c2 = b2[ptr++]) != 10 || ptr != sz && b2[ptr] == 32) continue;
            return ptr - 1;
        }
        return ptr;
    }

    public static final byte[] headerValue(byte[] b2, int start2, int end2) {
        byte[] data2 = new byte[end2 - start2];
        int out2 = 0;
        int last2 = 0;
        int in = start2;
        while (in < end2) {
            int ch = b2[in];
            if (ch != 32 || last2 != 10) {
                data2[out2++] = ch;
            }
            last2 = ch;
            ++in;
        }
        if (out2 == data2.length) {
            return data2;
        }
        return Arrays.copyOf(data2, out2);
    }

    @Deprecated
    public static final int headerEnd(byte[] b2, int ptr) {
        return RawParseUtils.nextLfSkippingSplitLines(b2, ptr);
    }

    public static final int headerStart(byte[] headerName, byte[] b2, int ptr) {
        if (ptr != 0) {
            ptr = RawParseUtils.nextLF(b2, ptr - 1);
        }
        while (ptr < b2.length - (headerName.length + 1)) {
            boolean found = true;
            byte[] byArray = headerName;
            int n = headerName.length;
            int n2 = 0;
            while (n2 < n) {
                byte element = byArray[n2];
                if (element != b2[ptr++]) {
                    found = false;
                    break;
                }
                ++n2;
            }
            if (found && b2[ptr++] == 32) {
                return ptr;
            }
            ptr = RawParseUtils.nextLF(b2, ptr);
        }
        return -1;
    }

    public static final boolean hasAnyKnownHeaders(byte[] b2) {
        return RawParseUtils.match(b2, 0, ObjectChecker.tree) != -1 || RawParseUtils.match(b2, 0, ObjectChecker.parent) != -1 || RawParseUtils.match(b2, 0, ObjectChecker.author) != -1 || RawParseUtils.match(b2, 0, ObjectChecker.committer) != -1 || RawParseUtils.match(b2, 0, ObjectChecker.encoding) != -1 || RawParseUtils.match(b2, 0, ObjectChecker.object) != -1 || RawParseUtils.match(b2, 0, ObjectChecker.type) != -1 || RawParseUtils.match(b2, 0, ObjectChecker.tag) != -1 || RawParseUtils.match(b2, 0, ObjectChecker.tagger) != -1;
    }

    public static final int prev(byte[] b2, int ptr, char chrA) {
        if (ptr == b2.length) {
            --ptr;
        }
        while (ptr >= 0) {
            if (b2[ptr--] != chrA) continue;
            return ptr;
        }
        return ptr;
    }

    public static final int prevLF(byte[] b2, int ptr) {
        return RawParseUtils.prev(b2, ptr, '\n');
    }

    public static final int prevLF(byte[] b2, int ptr, char chrA) {
        if (ptr == b2.length) {
            --ptr;
        }
        while (ptr >= 0) {
            byte c2;
            if ((c2 = b2[ptr--]) != chrA && c2 != 10) continue;
            return ptr;
        }
        return ptr;
    }

    public static final IntList lineMap(byte[] buf, int ptr, int end2) {
        IntList map2 = new IntList((end2 - ptr) / 36);
        map2.fillTo(1, Integer.MIN_VALUE);
        while (ptr < end2) {
            map2.add(ptr);
            ptr = RawParseUtils.nextLF(buf, ptr);
        }
        map2.add(end2);
        return map2;
    }

    public static final IntList lineMapOrBinary(byte[] buf, int ptr, int end2) throws BinaryBlobException {
        IntList map2 = new IntList((end2 - ptr) / 36);
        map2.add(Integer.MIN_VALUE);
        byte last2 = 10;
        while (ptr < end2) {
            byte curr;
            if (last2 == 10) {
                map2.add(ptr);
            }
            if (RawText.isBinary(curr = buf[ptr], last2)) {
                throw new BinaryBlobException();
            }
            last2 = curr;
            ++ptr;
        }
        if (last2 == 13) {
            throw new BinaryBlobException();
        }
        map2.add(end2);
        return map2;
    }

    public static final int author(byte[] b2, int ptr) {
        int sz = b2.length;
        if (ptr == 0) {
            ptr += 46;
        }
        while (ptr < sz && b2[ptr] == 112) {
            ptr += 48;
        }
        return RawParseUtils.match(b2, ptr, ObjectChecker.author);
    }

    public static final int committer(byte[] b2, int ptr) {
        int sz = b2.length;
        if (ptr == 0) {
            ptr += 46;
        }
        while (ptr < sz && b2[ptr] == 112) {
            ptr += 48;
        }
        if (ptr < sz && b2[ptr] == 97) {
            ptr = RawParseUtils.nextLF(b2, ptr);
        }
        return RawParseUtils.match(b2, ptr, ObjectChecker.committer);
    }

    public static final int tagger(byte[] b2, int ptr) {
        int sz = b2.length;
        if (ptr == 0) {
            ptr += 48;
        }
        while (ptr < sz) {
            if (b2[ptr] == 10) {
                return -1;
            }
            int m4 = RawParseUtils.match(b2, ptr, ObjectChecker.tagger);
            if (m4 >= 0) {
                return m4;
            }
            ptr = RawParseUtils.nextLF(b2, ptr);
        }
        return -1;
    }

    public static final int encoding(byte[] b2, int ptr) {
        int sz = b2.length;
        while (ptr < sz) {
            if (b2[ptr] == 10) {
                return -1;
            }
            if (b2[ptr] == 101) break;
            ptr = RawParseUtils.nextLF(b2, ptr);
        }
        return RawParseUtils.match(b2, ptr, ObjectChecker.encoding);
    }

    @Nullable
    public static String parseEncodingName(byte[] b2) {
        int enc = RawParseUtils.encoding(b2, 0);
        if (enc < 0) {
            return null;
        }
        int lf = RawParseUtils.nextLF(b2, enc);
        return RawParseUtils.decode(StandardCharsets.UTF_8, b2, enc, lf - 1);
    }

    public static Charset parseEncoding(byte[] b2) {
        String enc = RawParseUtils.parseEncodingName(b2);
        if (enc == null) {
            return StandardCharsets.UTF_8;
        }
        String name = enc.trim();
        try {
            return Charset.forName(name);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException badName) {
            Charset aliased = RawParseUtils.charsetForAlias(name);
            if (aliased != null) {
                return aliased;
            }
            throw badName;
        }
    }

    public static Charset guessEncoding(byte[] buffer) {
        try {
            return RawParseUtils.parseEncoding(buffer);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e2) {
            return StandardCharsets.UTF_8;
        }
    }

    public static PersonIdent parsePersonIdent(String in) {
        return RawParseUtils.parsePersonIdent(Constants.encode(in), 0);
    }

    public static PersonIdent parsePersonIdent(byte[] raw, int nameB) {
        Charset cs;
        try {
            cs = RawParseUtils.parseEncoding(raw);
        }
        catch (IllegalCharsetNameException | UnsupportedCharsetException e2) {
            cs = StandardCharsets.UTF_8;
        }
        int emailB = RawParseUtils.nextLF(raw, nameB, '<');
        int emailE = RawParseUtils.nextLF(raw, emailB, '>');
        if (emailB >= raw.length || raw[emailB] == 10 || emailE >= raw.length - 1 && raw[emailE - 1] != 62) {
            return null;
        }
        int nameEnd = emailB - 2 >= nameB && raw[emailB - 2] == 32 ? emailB - 2 : emailB - 1;
        String name = RawParseUtils.decode(cs, raw, nameB, nameEnd);
        String email = RawParseUtils.decode(cs, raw, emailB, emailE - 1);
        int tzBegin = RawParseUtils.lastIndexOfTrim(raw, ' ', RawParseUtils.nextLF(raw, emailE - 1) - 2) + 1;
        if (tzBegin <= emailE) {
            return new PersonIdent(name, email, Instant.EPOCH, ZoneOffset.UTC);
        }
        int whenBegin = Math.max(emailE, RawParseUtils.lastIndexOfTrim(raw, ' ', tzBegin - 1) + 1);
        if (whenBegin >= tzBegin - 1) {
            return new PersonIdent(name, email, Instant.EPOCH, ZoneOffset.UTC);
        }
        long when = RawParseUtils.parseLongBase10(raw, whenBegin, null);
        return new PersonIdent(name, email, Instant.ofEpochSecond(when), RawParseUtils.parseZoneOffset(raw, tzBegin, null));
    }

    public static PersonIdent parsePersonIdentOnly(byte[] raw, int nameB) {
        ZoneId tz;
        Instant when;
        int stop = RawParseUtils.nextLF(raw, nameB);
        int emailB = RawParseUtils.nextLF(raw, nameB, '<');
        int emailE = RawParseUtils.nextLF(raw, emailB, '>');
        String email = emailE < stop ? RawParseUtils.decode(raw, emailB, emailE - 1) : "invalid";
        String name = emailB < stop ? RawParseUtils.decode(raw, nameB, emailB - 2) : RawParseUtils.decode(raw, nameB, stop);
        MutableInteger ptrout = new MutableInteger();
        if (emailE < stop) {
            when = Instant.ofEpochSecond(RawParseUtils.parseLongBase10(raw, emailE + 1, ptrout));
            tz = RawParseUtils.parseZoneOffset(raw, ptrout.value, null);
        } else {
            when = Instant.EPOCH;
            tz = ZoneOffset.UTC;
        }
        return new PersonIdent(name, email, when, tz);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static int endOfFooterLineKey(byte[] raw, int ptr) {
        try {
            while (true) {
                byte c2;
                if (footerLineKeyChars[c2 = raw[ptr]] == 0) {
                    if (c2 == 58) {
                        return ptr;
                    }
                    return -1;
                }
                ++ptr;
            }
        }
        catch (ArrayIndexOutOfBoundsException e2) {
            return -1;
        }
    }

    public static String decode(byte[] buffer) {
        return RawParseUtils.decode(buffer, 0, buffer.length);
    }

    public static String decode(byte[] buffer, int start2, int end2) {
        return RawParseUtils.decode(StandardCharsets.UTF_8, buffer, start2, end2);
    }

    public static String decode(Charset cs, byte[] buffer) {
        return RawParseUtils.decode(cs, buffer, 0, buffer.length);
    }

    public static String decode(Charset cs, byte[] buffer, int start2, int end2) {
        try {
            return RawParseUtils.decodeNoFallback(cs, buffer, start2, end2);
        }
        catch (CharacterCodingException e2) {
            return RawParseUtils.extractBinaryString(buffer, start2, end2);
        }
    }

    public static String decodeNoFallback(Charset cs, byte[] buffer, int start2, int end2) throws CharacterCodingException {
        ByteBuffer b2 = ByteBuffer.wrap(buffer, start2, end2 - start2);
        b2.mark();
        try {
            return RawParseUtils.decode(b2, StandardCharsets.UTF_8);
        }
        catch (CharacterCodingException e2) {
            Charset defcs;
            b2.reset();
            if (!cs.equals(StandardCharsets.UTF_8)) {
                try {
                    return RawParseUtils.decode(b2, cs);
                }
                catch (CharacterCodingException e3) {
                    b2.reset();
                }
            }
            if (!(defcs = SystemReader.getInstance().getDefaultCharset()).equals(cs) && !defcs.equals(StandardCharsets.UTF_8)) {
                try {
                    return RawParseUtils.decode(b2, defcs);
                }
                catch (CharacterCodingException e4) {
                    b2.reset();
                }
            }
            throw new CharacterCodingException();
        }
    }

    public static String extractBinaryString(byte[] buffer, int start2, int end2) {
        StringBuilder r = new StringBuilder(end2 - start2);
        int i2 = start2;
        while (i2 < end2) {
            r.append((char)(buffer[i2] & 0xFF));
            ++i2;
        }
        return r.toString();
    }

    private static String decode(ByteBuffer b2, Charset charset) throws CharacterCodingException {
        CharsetDecoder d2 = charset.newDecoder();
        d2.onMalformedInput(CodingErrorAction.REPORT);
        d2.onUnmappableCharacter(CodingErrorAction.REPORT);
        return d2.decode(b2).toString();
    }

    public static final int commitMessage(byte[] b2, int ptr) {
        int sz = b2.length;
        if (ptr == 0) {
            ptr += 46;
        }
        while (ptr < sz && b2[ptr] == 112) {
            ptr += 48;
        }
        return RawParseUtils.tagMessage(b2, ptr);
    }

    public static final int tagMessage(byte[] b2, int ptr) {
        int sz = b2.length;
        if (ptr == 0) {
            ptr += 48;
        }
        while (ptr < sz && b2[ptr] != 10) {
            ptr = RawParseUtils.nextLF(b2, ptr);
        }
        if (ptr < sz && b2[ptr] == 10) {
            return ptr + 1;
        }
        return -1;
    }

    public static final int endOfParagraph(byte[] b2, int start2) {
        int ptr = start2;
        int sz = b2.length;
        while (ptr < sz && b2[ptr] != 10 && b2[ptr] != 13) {
            ptr = RawParseUtils.nextLF(b2, ptr);
        }
        if (ptr > start2 && b2[ptr - 1] == 10) {
            --ptr;
        }
        if (ptr > start2 && b2[ptr - 1] == 13) {
            --ptr;
        }
        return ptr;
    }

    public static int lastIndexOfTrim(byte[] raw, char ch, int pos) {
        while (pos >= 0 && raw[pos] == 32) {
            --pos;
        }
        while (pos >= 0 && raw[pos] != ch) {
            --pos;
        }
        return pos;
    }

    private static Charset charsetForAlias(String name) {
        return encodingAliases.get(StringUtils.toLowerCase(name));
    }

    private RawParseUtils() {
    }
}

