/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.Constants;
import org.eclipse.jgit.util.RawCharSequence;
import org.eclipse.jgit.util.StringUtils;

public class RawSubStringPattern {
    private final String needleString;
    private final byte[] needle;

    public RawSubStringPattern(String patternText) {
        if (patternText.length() == 0) {
            throw new IllegalArgumentException(JGitText.get().cannotMatchOnEmptyString);
        }
        this.needleString = patternText;
        byte[] b2 = Constants.encode(patternText);
        this.needle = new byte[b2.length];
        int i2 = 0;
        while (i2 < b2.length) {
            this.needle[i2] = RawSubStringPattern.lc(b2[i2]);
            ++i2;
        }
    }

    public int match(RawCharSequence rcs) {
        int needleLen = this.needle.length;
        byte first2 = this.needle[0];
        byte[] text = rcs.buffer;
        int matchPos = rcs.startPtr;
        int maxPos = rcs.endPtr - needleLen;
        while (matchPos <= maxPos) {
            block6: {
                if (RawSubStringPattern.neq(first2, text[matchPos])) {
                    while (++matchPos <= maxPos && RawSubStringPattern.neq(first2, text[matchPos])) {
                    }
                    if (matchPos > maxPos) {
                        return -1;
                    }
                }
                int si = matchPos + 1;
                int j2 = 1;
                while (j2 < needleLen) {
                    if (!RawSubStringPattern.neq(this.needle[j2], text[si])) {
                        ++j2;
                        ++si;
                        continue;
                    }
                    break block6;
                }
                return matchPos;
            }
            ++matchPos;
        }
        return -1;
    }

    private static final boolean neq(byte a2, byte b2) {
        return a2 != b2 && a2 != RawSubStringPattern.lc(b2);
    }

    private static final byte lc(byte q) {
        return (byte)StringUtils.toLowerCase((char)(q & 0xFF));
    }

    public String pattern() {
        return this.needleString;
    }

    public String toString() {
        return this.pattern();
    }
}

