/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.text.MessageFormat;
import java.util.Locale;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.SignatureVerifier;
import org.eclipse.jgit.util.GitDateFormatter;
import org.eclipse.jgit.util.StringUtils;

public final class SignatureUtils {
    private SignatureUtils() {
    }

    public static String toString(SignatureVerifier.SignatureVerification verification, PersonIdent creator, GitDateFormatter formatter) {
        StringBuilder result2 = new StringBuilder();
        if (verification.creationDate() != null) {
            PersonIdent dateId = new PersonIdent(creator, verification.creationDate().toInstant());
            result2.append(MessageFormat.format(JGitText.get().verifySignatureMade, formatter.formatDate(dateId)));
            result2.append('\n');
        }
        result2.append(MessageFormat.format(JGitText.get().verifySignatureKey, verification.keyFingerprint().toUpperCase(Locale.ROOT)));
        result2.append('\n');
        if (!StringUtils.isEmptyOrNull(verification.signer())) {
            result2.append(MessageFormat.format(JGitText.get().verifySignatureIssuer, verification.signer()));
            result2.append('\n');
        }
        String msg = verification.verified() ? (verification.expired() ? JGitText.get().verifySignatureExpired : JGitText.get().verifySignatureGood) : JGitText.get().verifySignatureBad;
        result2.append(MessageFormat.format(msg, verification.keyUser()));
        if (!SignatureVerifier.TrustLevel.UNKNOWN.equals((Object)verification.trustLevel())) {
            result2.append(" " + MessageFormat.format(JGitText.get().verifySignatureTrust, verification.trustLevel().name().toLowerCase(Locale.ROOT)));
        }
        result2.append('\n');
        msg = verification.message();
        if (!StringUtils.isEmptyOrNull(msg)) {
            result2.append(msg);
            result2.append('\n');
        }
        return result2.toString();
    }
}

