/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.IOException;
import java.text.MessageFormat;
import java.util.concurrent.TimeUnit;
import org.eclipse.jgit.annotations.Nullable;
import org.eclipse.jgit.errors.CommandFailedException;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.jgit.transport.RemoteSession;
import org.eclipse.jgit.transport.SshSessionFactory;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.jgit.util.FS;
import org.eclipse.jgit.util.io.MessageWriter;
import org.eclipse.jgit.util.io.StreamCopyThread;

public class SshSupport {
    public static String runSshCommand(URIish sshUri, @Nullable CredentialsProvider provider2, FS fs, String command2, int timeout2) throws IOException, CommandFailedException {
        String out2;
        MessageWriter stdout;
        MessageWriter stderr;
        CommandFailedException failure;
        Process process2;
        RemoteSession session2;
        block48: {
            StreamCopyThread outThread;
            block46: {
                StreamCopyThread errorThread;
                block40: {
                    session2 = null;
                    process2 = null;
                    errorThread = null;
                    outThread = null;
                    failure = null;
                    stderr = new MessageWriter();
                    stdout = new MessageWriter();
                    try {
                        long start2 = System.nanoTime();
                        session2 = SshSessionFactory.getInstance().getSession(sshUri, provider2, fs, 1000 * timeout2);
                        int commandTimeout = timeout2;
                        if (timeout2 > 0) {
                            commandTimeout = SshSupport.checkTimeout(command2, timeout2, start2);
                        }
                        process2 = session2.exec(command2, commandTimeout);
                        if (timeout2 > 0) {
                            commandTimeout = SshSupport.checkTimeout(command2, timeout2, start2);
                        }
                        errorThread = new StreamCopyThread(process2.getErrorStream(), stderr.getRawStream());
                        errorThread.start();
                        outThread = new StreamCopyThread(process2.getInputStream(), stdout.getRawStream());
                        outThread.start();
                        try {
                            boolean finished = false;
                            if (timeout2 <= 0) {
                                process2.waitFor();
                                finished = true;
                            } else {
                                finished = process2.waitFor(commandTimeout, TimeUnit.SECONDS);
                            }
                            if (finished) {
                                out2 = stdout.toString();
                                break block40;
                            }
                            out2 = null;
                        }
                        catch (InterruptedException e2) {
                            out2 = null;
                        }
                    }
                    catch (Throwable throwable) {
                        block44: {
                            block42: {
                                if (errorThread != null) {
                                    try {
                                        try {
                                            errorThread.halt();
                                        }
                                        catch (InterruptedException interruptedException) {
                                            errorThread = null;
                                            break block42;
                                        }
                                    }
                                    catch (Throwable throwable2) {
                                        errorThread = null;
                                        throw throwable2;
                                    }
                                    errorThread = null;
                                }
                            }
                            if (outThread != null) {
                                try {
                                    try {
                                        outThread.halt();
                                    }
                                    catch (InterruptedException interruptedException) {
                                        outThread = null;
                                        break block44;
                                    }
                                }
                                catch (Throwable throwable3) {
                                    outThread = null;
                                    throw throwable3;
                                }
                                outThread = null;
                            }
                        }
                        if (process2 != null) {
                            try {
                                if (process2.exitValue() != 0) {
                                    failure = new CommandFailedException(process2.exitValue(), MessageFormat.format(JGitText.get().sshCommandFailed, command2, stderr.toString()));
                                }
                                String out3 = stdout.toString();
                            }
                            catch (IllegalThreadStateException e3) {
                                failure = new CommandFailedException(0, MessageFormat.format(JGitText.get().sshCommandTimeout, command2, timeout2));
                            }
                            process2.destroy();
                        }
                        stderr.close();
                        stdout.close();
                        if (session2 != null) {
                            SshSessionFactory.getInstance().releaseSession(session2);
                        }
                        throw throwable;
                    }
                }
                if (errorThread != null) {
                    try {
                        try {
                            errorThread.halt();
                        }
                        catch (InterruptedException e3) {
                            errorThread = null;
                            break block46;
                        }
                    }
                    catch (Throwable throwable) {
                        errorThread = null;
                        throw throwable;
                    }
                    errorThread = null;
                }
            }
            if (outThread != null) {
                try {
                    try {
                        outThread.halt();
                    }
                    catch (InterruptedException e3) {
                        outThread = null;
                        break block48;
                    }
                }
                catch (Throwable throwable) {
                    outThread = null;
                    throw throwable;
                }
                outThread = null;
            }
        }
        if (process2 != null) {
            try {
                if (process2.exitValue() != 0) {
                    failure = new CommandFailedException(process2.exitValue(), MessageFormat.format(JGitText.get().sshCommandFailed, command2, stderr.toString()));
                }
                out2 = stdout.toString();
            }
            catch (IllegalThreadStateException e4) {
                failure = new CommandFailedException(0, MessageFormat.format(JGitText.get().sshCommandTimeout, command2, timeout2));
            }
            process2.destroy();
        }
        stderr.close();
        stdout.close();
        if (session2 != null) {
            SshSessionFactory.getInstance().releaseSession(session2);
        }
        if (failure != null) {
            throw failure;
        }
        return out2;
    }

    private static int checkTimeout(String command2, int timeout2, long since) throws CommandFailedException {
        long elapsed = System.nanoTime() - since;
        int newTimeout = timeout2 - (int)TimeUnit.NANOSECONDS.toSeconds(elapsed);
        if (newTimeout <= 0) {
            throw new CommandFailedException(0, MessageFormat.format(JGitText.get().sshCommandTimeout, command2, timeout2));
        }
        return newTimeout;
    }
}

