/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.NullProgressMonitor;
import org.eclipse.jgit.lib.ProgressMonitor;
import org.eclipse.jgit.util.IO;
import org.eclipse.jgit.util.RawParseUtils;

public abstract class TemporaryBuffer
extends OutputStream {
    protected static final int DEFAULT_IN_CORE_LIMIT = 0x100000;
    ArrayList<Block> blocks;
    private int inCoreLimit;
    private int initialBlocks;
    private OutputStream overflow;

    protected TemporaryBuffer(int limit) {
        this(limit, limit);
    }

    protected TemporaryBuffer(int estimatedSize, int limit) {
        if (estimatedSize > limit) {
            throw new IllegalArgumentException();
        }
        this.inCoreLimit = limit;
        this.initialBlocks = (estimatedSize - 1) / 8192 + 1;
        this.reset();
    }

    @Override
    public void write(int b2) throws IOException {
        if (this.overflow != null) {
            this.overflow.write(b2);
            return;
        }
        Block s2 = this.last();
        if (s2.isFull()) {
            if (this.reachedInCoreLimit()) {
                this.overflow.write(b2);
                return;
            }
            s2 = new Block();
            this.blocks.add(s2);
        }
        s2.buffer[s2.count++] = (byte)b2;
    }

    @Override
    public void write(byte[] b2, int off, int len2) throws IOException {
        if (this.overflow == null) {
            while (len2 > 0) {
                Block s2 = this.last();
                if (s2.isFull()) {
                    if (this.reachedInCoreLimit()) break;
                    s2 = new Block();
                    this.blocks.add(s2);
                }
                int n = Math.min(s2.buffer.length - s2.count, len2);
                System.arraycopy(b2, off, s2.buffer, s2.count, n);
                s2.count += n;
                len2 -= n;
                off += n;
            }
        }
        if (len2 > 0) {
            this.overflow.write(b2, off, len2);
        }
    }

    protected void doFlush() throws IOException {
        if (this.overflow == null) {
            this.switchToOverflow();
        }
        this.overflow.flush();
    }

    public void copy(InputStream in) throws IOException {
        int n;
        if (this.blocks != null) {
            while (true) {
                Block s2;
                if ((s2 = this.last()).isFull()) {
                    if (this.reachedInCoreLimit()) break;
                    s2 = new Block();
                    this.blocks.add(s2);
                }
                if ((n = in.read(s2.buffer, s2.count, s2.buffer.length - s2.count)) < 1) {
                    return;
                }
                s2.count += n;
            }
        }
        byte[] tmp = new byte[8192];
        while ((n = in.read(tmp)) > 0) {
            this.overflow.write(tmp, 0, n);
        }
    }

    public long length() {
        return this.inCoreLength();
    }

    private long inCoreLength() {
        Block last2 = this.last();
        return ((long)this.blocks.size() - 1L) * 8192L + (long)last2.count;
    }

    public byte[] toByteArray() throws IOException {
        long len2 = this.length();
        if (Integer.MAX_VALUE < len2) {
            throw new OutOfMemoryError(JGitText.get().lengthExceedsMaximumArraySize);
        }
        byte[] out2 = new byte[(int)len2];
        int outPtr = 0;
        for (Block b2 : this.blocks) {
            System.arraycopy(b2.buffer, 0, out2, outPtr, b2.count);
            outPtr += b2.count;
        }
        return out2;
    }

    public String toString(int limit) {
        try {
            return RawParseUtils.decode(this.toByteArray(limit));
        }
        catch (IOException e2) {
            throw new UncheckedIOException(e2);
        }
    }

    public byte[] toByteArray(int limit) throws IOException {
        long len2 = Math.min(this.length(), (long)limit);
        if (Integer.MAX_VALUE < len2) {
            throw new OutOfMemoryError(JGitText.get().lengthExceedsMaximumArraySize);
        }
        int length = (int)len2;
        byte[] out2 = new byte[length];
        int outPtr = 0;
        for (Block b2 : this.blocks) {
            int toCopy = Math.min(length - outPtr, b2.count);
            System.arraycopy(b2.buffer, 0, out2, outPtr, toCopy);
            if ((outPtr += toCopy) == length) break;
        }
        return out2;
    }

    public void writeTo(OutputStream os, ProgressMonitor pm) throws IOException {
        if (pm == null) {
            pm = NullProgressMonitor.INSTANCE;
        }
        for (Block b2 : this.blocks) {
            os.write(b2.buffer, 0, b2.count);
            pm.update(b2.count / 1024);
        }
    }

    public InputStream openInputStream() throws IOException {
        return new BlockInputStream();
    }

    public InputStream openInputStreamWithAutoDestroy() throws IOException {
        return new BlockInputStream(this){

            @Override
            public void close() throws IOException {
                super.close();
                this.destroy();
            }
        };
    }

    public void reset() {
        if (this.overflow != null) {
            this.destroy();
        }
        if (this.blocks != null) {
            this.blocks.clear();
        } else {
            this.blocks = new ArrayList(this.initialBlocks);
        }
        this.blocks.add(new Block(Math.min(this.inCoreLimit, 8192)));
    }

    protected abstract OutputStream overflow() throws IOException;

    private Block last() {
        return this.blocks.get(this.blocks.size() - 1);
    }

    private boolean reachedInCoreLimit() throws IOException {
        if (this.inCoreLength() < (long)this.inCoreLimit) {
            return false;
        }
        this.switchToOverflow();
        return true;
    }

    private void switchToOverflow() throws IOException {
        this.overflow = this.overflow();
        Block last2 = this.blocks.remove(this.blocks.size() - 1);
        for (Block b2 : this.blocks) {
            this.overflow.write(b2.buffer, 0, b2.count);
        }
        this.blocks = null;
        this.overflow = new BufferedOutputStream(this.overflow, 8192);
        this.overflow.write(last2.buffer, 0, last2.count);
    }

    @Override
    public void close() throws IOException {
        if (this.overflow != null) {
            try {
                this.overflow.close();
            }
            finally {
                this.overflow = null;
            }
        }
    }

    public void destroy() {
        this.blocks = null;
        if (this.overflow != null) {
            try {
                try {
                    this.overflow.close();
                }
                catch (IOException iOException) {
                    this.overflow = null;
                }
            }
            finally {
                this.overflow = null;
            }
        }
    }

    static class Block {
        static final int SZ = 8192;
        final byte[] buffer;
        int count;

        Block() {
            this.buffer = new byte[8192];
        }

        Block(int sz) {
            this.buffer = new byte[sz];
        }

        boolean isFull() {
            return this.count == this.buffer.length;
        }
    }

    private class BlockInputStream
    extends InputStream {
        private byte[] singleByteBuffer;
        private int blockIndex;
        private Block block;
        private int blockPos;

        BlockInputStream() {
            this.block = TemporaryBuffer.this.blocks.get(this.blockIndex);
        }

        @Override
        public int read() throws IOException {
            int n;
            if (this.singleByteBuffer == null) {
                this.singleByteBuffer = new byte[1];
            }
            return (n = this.read(this.singleByteBuffer)) == 1 ? this.singleByteBuffer[0] & 0xFF : -1;
        }

        @Override
        public long skip(long cnt) throws IOException {
            long skipped = 0L;
            while (0L < cnt) {
                int n = (int)Math.min((long)(this.block.count - this.blockPos), cnt);
                if (n > 0) {
                    this.blockPos += n;
                    skipped += (long)n;
                    cnt -= (long)n;
                    continue;
                }
                if (!this.nextBlock()) break;
            }
            return skipped;
        }

        @Override
        public int read(byte[] b2, int off, int len2) throws IOException {
            if (len2 == 0) {
                return 0;
            }
            int copied2 = 0;
            while (len2 > 0) {
                int c2 = Math.min(this.block.count - this.blockPos, len2);
                if (c2 > 0) {
                    System.arraycopy(this.block.buffer, this.blockPos, b2, off, c2);
                    this.blockPos += c2;
                    off += c2;
                    len2 -= c2;
                    copied2 += c2;
                    continue;
                }
                if (!this.nextBlock()) break;
            }
            return copied2 > 0 ? copied2 : -1;
        }

        private boolean nextBlock() {
            if (++this.blockIndex < TemporaryBuffer.this.blocks.size()) {
                this.block = TemporaryBuffer.this.blocks.get(this.blockIndex);
                this.blockPos = 0;
                return true;
            }
            return false;
        }
    }

    public static class Heap
    extends TemporaryBuffer {
        public Heap(int limit) {
            super(limit);
        }

        public Heap(int estimatedSize, int limit) {
            super(estimatedSize, limit);
        }

        @Override
        protected OutputStream overflow() throws IOException {
            throw new IOException(JGitText.get().inMemoryBufferLimitExceeded);
        }
    }

    public static class LocalFile
    extends TemporaryBuffer {
        private final File directory;
        private File onDiskFile;

        public LocalFile(File directory) {
            this(directory, 0x100000);
        }

        public LocalFile(File directory, int inCoreLimit) {
            super(inCoreLimit);
            this.directory = directory;
        }

        @Override
        protected OutputStream overflow() throws IOException {
            this.onDiskFile = File.createTempFile("jgit_", ".buf", this.directory);
            return new BufferedOutputStream(new FileOutputStream(this.onDiskFile));
        }

        @Override
        public long length() {
            if (this.onDiskFile == null) {
                return super.length();
            }
            return this.onDiskFile.length();
        }

        @Override
        public byte[] toByteArray() throws IOException {
            if (this.onDiskFile == null) {
                return super.toByteArray();
            }
            long len2 = this.length();
            if (Integer.MAX_VALUE < len2) {
                throw new OutOfMemoryError(JGitText.get().lengthExceedsMaximumArraySize);
            }
            byte[] out2 = new byte[(int)len2];
            Throwable throwable = null;
            Object var5_5 = null;
            try (FileInputStream in = new FileInputStream(this.onDiskFile);){
                IO.readFully(in, out2, 0, (int)len2);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return out2;
        }

        @Override
        public byte[] toByteArray(int limit) throws IOException {
            if (this.onDiskFile == null) {
                return super.toByteArray(limit);
            }
            long len2 = Math.min(this.length(), (long)limit);
            if (Integer.MAX_VALUE < len2) {
                throw new OutOfMemoryError(JGitText.get().lengthExceedsMaximumArraySize);
            }
            byte[] out2 = new byte[(int)len2];
            Throwable throwable = null;
            Object var6_6 = null;
            try (FileInputStream in = new FileInputStream(this.onDiskFile);){
                int chunk;
                int read2 = 0;
                while ((chunk = in.read(out2, read2, out2.length - read2)) >= 0) {
                    if ((read2 += chunk) != out2.length) continue;
                    break;
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return out2;
        }

        @Override
        public void writeTo(OutputStream os, ProgressMonitor pm) throws IOException {
            if (this.onDiskFile == null) {
                super.writeTo(os, pm);
                return;
            }
            if (pm == null) {
                pm = NullProgressMonitor.INSTANCE;
            }
            Throwable throwable = null;
            Object var4_5 = null;
            try (FileInputStream in = new FileInputStream(this.onDiskFile);){
                int cnt;
                byte[] buf = new byte[8192];
                while ((cnt = in.read(buf)) >= 0) {
                    os.write(buf, 0, cnt);
                    pm.update(cnt / 1024);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }

        @Override
        public InputStream openInputStream() throws IOException {
            if (this.onDiskFile == null) {
                return super.openInputStream();
            }
            return new FileInputStream(this.onDiskFile);
        }

        @Override
        public InputStream openInputStreamWithAutoDestroy() throws IOException {
            if (this.onDiskFile == null) {
                return super.openInputStreamWithAutoDestroy();
            }
            return new FileInputStream(this.onDiskFile){

                @Override
                public void close() throws IOException {
                    super.close();
                    this.destroy();
                }
            };
        }

        @Override
        public void destroy() {
            super.destroy();
            if (this.onDiskFile != null) {
                try {
                    if (!this.onDiskFile.delete()) {
                        this.onDiskFile.deleteOnExit();
                    }
                }
                finally {
                    this.onDiskFile = null;
                }
            }
        }
    }
}

