/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.jgit.diff.RawText;

public class AutoCRLFInputStream
extends InputStream {
    private final byte[] single = new byte[1];
    private final byte[] buf = new byte[RawText.getBufferSize()];
    private final InputStream in;
    private int cnt;
    private int ptr;
    private boolean isBinary;
    private boolean detectBinary;
    private byte last;

    public AutoCRLFInputStream(InputStream in, boolean detectBinary) {
        this.in = in;
        this.detectBinary = detectBinary;
    }

    @Override
    public int read() throws IOException {
        int read2 = this.read(this.single, 0, 1);
        return read2 == 1 ? this.single[0] & 0xFF : -1;
    }

    @Override
    public int read(byte[] bs, int off, int len2) throws IOException {
        int n;
        if (len2 == 0) {
            return 0;
        }
        if (this.cnt == -1) {
            return -1;
        }
        int i2 = off;
        int end2 = off + len2;
        while (i2 < end2) {
            if (this.ptr == this.cnt && !this.fillBuffer()) break;
            byte b2 = this.buf[this.ptr++];
            if (this.isBinary || b2 != 10) {
                bs[i2++] = this.last = b2;
                continue;
            }
            if (b2 == 10) {
                if (this.last == 13) {
                    bs[i2++] = this.last = b2;
                    continue;
                }
                int n2 = i2++;
                this.last = (byte)13;
                bs[n2] = 13;
                --this.ptr;
                continue;
            }
            bs[i2++] = this.last = b2;
        }
        int n3 = n = i2 == off ? -1 : i2 - off;
        if (n > 0) {
            this.last = bs[i2 - 1];
        }
        return n;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private boolean fillBuffer() throws IOException {
        this.cnt = 0;
        while (this.cnt < this.buf.length) {
            int n = this.in.read(this.buf, this.cnt, this.buf.length - this.cnt);
            if (n < 0) break;
            this.cnt += n;
        }
        if (this.cnt < 1) {
            this.cnt = -1;
            return false;
        }
        if (this.detectBinary) {
            this.isBinary = RawText.isBinary(this.buf, this.cnt, this.cnt < this.buf.length);
            this.detectBinary = false;
        }
        this.ptr = 0;
        return true;
    }
}

