/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import org.eclipse.jgit.diff.RawText;

public class AutoLFInputStream
extends InputStream {
    private final byte[] single = new byte[1];
    private final byte[] buf = new byte[RawText.getBufferSize()];
    private final InputStream in;
    private int cnt;
    private int ptr;
    private boolean passAsIs;
    private boolean isBinary;
    private boolean detectBinary;
    private final boolean abortIfBinary;
    private final boolean forCheckout;

    public static AutoLFInputStream create(InputStream in, StreamFlag ... flags) {
        if (flags == null) {
            return new AutoLFInputStream(in, null);
        }
        EnumSet<StreamFlag> set2 = EnumSet.noneOf(StreamFlag.class);
        set2.addAll(Arrays.asList(flags));
        return new AutoLFInputStream(in, set2);
    }

    public AutoLFInputStream(InputStream in, Set<StreamFlag> flags) {
        this.in = in;
        this.detectBinary = flags != null && flags.contains((Object)StreamFlag.DETECT_BINARY);
        this.abortIfBinary = flags != null && flags.contains((Object)StreamFlag.ABORT_IF_BINARY);
        this.forCheckout = flags != null && flags.contains((Object)StreamFlag.FOR_CHECKOUT);
    }

    @Override
    public int read() throws IOException {
        int read2 = this.read(this.single, 0, 1);
        return read2 == 1 ? this.single[0] & 0xFF : -1;
    }

    @Override
    public int read(byte[] bs, int off, int len2) throws IOException {
        if (len2 == 0) {
            return 0;
        }
        if (this.cnt == -1) {
            return -1;
        }
        int i2 = off;
        int end2 = off + len2;
        while (i2 < end2) {
            if (this.ptr == this.cnt && !this.fillBuffer()) break;
            byte b2 = this.buf[this.ptr++];
            if (this.passAsIs || b2 != 13) {
                bs[i2++] = b2;
                continue;
            }
            if (this.ptr == this.cnt && !this.fillBuffer()) {
                bs[i2++] = 13;
                break;
            }
            if (this.buf[this.ptr] == 10) {
                bs[i2++] = 10;
                ++this.ptr;
                continue;
            }
            bs[i2++] = 13;
        }
        return i2 == off ? -1 : i2 - off;
    }

    public boolean isBinary() {
        return this.isBinary;
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    private boolean fillBuffer() throws IOException {
        this.cnt = 0;
        while (this.cnt < this.buf.length) {
            int n = this.in.read(this.buf, this.cnt, this.buf.length - this.cnt);
            if (n < 0) break;
            this.cnt += n;
        }
        if (this.cnt < 1) {
            this.cnt = -1;
            return false;
        }
        if (this.detectBinary) {
            this.passAsIs = this.isBinary = RawText.isBinary(this.buf, this.cnt, this.cnt < this.buf.length);
            this.detectBinary = false;
            if (this.isBinary && this.abortIfBinary) {
                throw new IsBinaryException();
            }
            if (!this.passAsIs && this.forCheckout) {
                this.passAsIs = RawText.isCrLfText(this.buf, this.cnt, this.cnt < this.buf.length);
            }
        }
        this.ptr = 0;
        return true;
    }

    public static class IsBinaryException
    extends IOException {
        private static final long serialVersionUID = 1L;

        IsBinaryException() {
        }
    }

    public static enum StreamFlag {
        DETECT_BINARY,
        ABORT_IF_BINARY,
        FOR_CHECKOUT;

    }
}

