/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.IOException;
import java.io.OutputStream;
import org.eclipse.jgit.diff.RawText;

public class AutoLFOutputStream
extends OutputStream {
    private final OutputStream out;
    private int buf = -1;
    private byte[] binbuf = new byte[RawText.getBufferSize()];
    private byte[] onebytebuf = new byte[1];
    private int binbufcnt = 0;
    private boolean detectBinary;
    private boolean isBinary;

    public AutoLFOutputStream(OutputStream out2) {
        this(out2, true);
    }

    public AutoLFOutputStream(OutputStream out2, boolean detectBinary) {
        this.out = out2;
        this.detectBinary = detectBinary;
    }

    @Override
    public void write(int b2) throws IOException {
        this.onebytebuf[0] = (byte)b2;
        this.write(this.onebytebuf, 0, 1);
    }

    @Override
    public void write(byte[] b2) throws IOException {
        int overflow = this.buffer(b2, 0, b2.length);
        if (overflow > 0) {
            this.write(b2, b2.length - overflow, overflow);
        }
    }

    @Override
    public void write(byte[] b2, int startOff, int startLen) throws IOException {
        int overflow = this.buffer(b2, startOff, startLen);
        if (overflow <= 0) {
            return;
        }
        int off = startOff + startLen - overflow;
        int len2 = overflow;
        int lastw = off;
        if (this.isBinary) {
            this.out.write(b2, off, len2);
            return;
        }
        int i2 = off;
        while (i2 < off + len2) {
            byte c2 = b2[i2];
            switch (c2) {
                case 13: {
                    if (lastw < i2) {
                        this.out.write(b2, lastw, i2 - lastw);
                    }
                    lastw = i2 + 1;
                    this.buf = 13;
                    break;
                }
                case 10: {
                    if (this.buf == 13) {
                        this.out.write(10);
                        lastw = i2 + 1;
                        this.buf = -1;
                        break;
                    }
                    if (lastw < i2 + 1) {
                        this.out.write(b2, lastw, i2 + 1 - lastw);
                    }
                    lastw = i2 + 1;
                    break;
                }
                default: {
                    if (this.buf == 13) {
                        this.out.write(13);
                        lastw = i2;
                    }
                    this.buf = -1;
                }
            }
            ++i2;
        }
        if (lastw < off + len2) {
            this.out.write(b2, lastw, off + len2 - lastw);
        }
    }

    private int buffer(byte[] b2, int off, int len2) throws IOException {
        if (this.binbufcnt > this.binbuf.length) {
            return len2;
        }
        int copy2 = Math.min(this.binbuf.length - this.binbufcnt, len2);
        System.arraycopy(b2, off, this.binbuf, this.binbufcnt, copy2);
        this.binbufcnt += copy2;
        int remaining = len2 - copy2;
        if (remaining > 0) {
            this.decideMode(false);
        }
        return remaining;
    }

    private void decideMode(boolean complete) throws IOException {
        if (this.detectBinary) {
            this.isBinary = RawText.isBinary(this.binbuf, this.binbufcnt, complete);
            if (!this.isBinary) {
                this.isBinary = RawText.isCrLfText(this.binbuf, this.binbufcnt, complete);
            }
            this.detectBinary = false;
        }
        int cachedLen = this.binbufcnt;
        this.binbufcnt = this.binbuf.length + 1;
        this.write(this.binbuf, 0, cachedLen);
    }

    @Override
    public void flush() throws IOException {
        if (this.binbufcnt <= this.binbuf.length) {
            this.decideMode(true);
        }
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.flush();
        if (this.buf == 13) {
            this.out.write(this.buf);
            this.buf = -1;
        }
        this.out.close();
    }
}

