/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StreamCorruptedException;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;

public class BinaryDeltaInputStream
extends InputStream {
    private final byte[] base;
    private final InputStream delta;
    private long resultLength;
    private long toDeliver = -1L;
    private int fromBase;
    private int fromDelta;
    private int baseOffset = -1;

    public BinaryDeltaInputStream(byte[] base, InputStream delta) {
        this.base = base;
        this.delta = delta;
    }

    @Override
    public int read() throws IOException {
        int b2 = this.readNext();
        if (b2 >= 0) {
            --this.toDeliver;
        }
        return b2;
    }

    @Override
    public int read(byte[] b2, int off, int len2) throws IOException {
        return super.read(b2, off, len2);
    }

    private void initialize() throws IOException {
        long baseSize = this.readVarInt(this.delta);
        if (baseSize > Integer.MAX_VALUE || baseSize < 0L || (int)baseSize != this.base.length) {
            throw new IOException(MessageFormat.format(JGitText.get().binaryDeltaBaseLengthMismatch, this.base.length, baseSize));
        }
        this.resultLength = this.readVarInt(this.delta);
        if (this.resultLength < 0L) {
            throw new StreamCorruptedException(JGitText.get().binaryDeltaInvalidResultLength);
        }
        this.toDeliver = this.resultLength;
        this.baseOffset = 0;
    }

    private int readNext() throws IOException {
        if (this.baseOffset < 0) {
            this.initialize();
        }
        if (this.fromBase > 0) {
            --this.fromBase;
            return this.base[this.baseOffset++] & 0xFF;
        }
        if (this.fromDelta > 0) {
            --this.fromDelta;
            return this.delta.read();
        }
        int command2 = this.delta.read();
        if (command2 < 0) {
            return -1;
        }
        if ((command2 & 0x80) != 0) {
            long copyOffset = 0L;
            int i2 = 1;
            int shift = 0;
            while (i2 < 16) {
                if ((command2 & i2) != 0) {
                    copyOffset |= (long)this.next(this.delta) << shift;
                }
                i2 *= 2;
                shift += 8;
            }
            int copySize = 0;
            int i3 = 16;
            int shift2 = 0;
            while (i3 < 128) {
                if ((command2 & i3) != 0) {
                    copySize |= this.next(this.delta) << shift2;
                }
                i3 *= 2;
                shift2 += 8;
            }
            if (copySize == 0) {
                copySize = 65536;
            }
            if (copyOffset > (long)(this.base.length - copySize)) {
                throw new StreamCorruptedException(MessageFormat.format(JGitText.get().binaryDeltaInvalidOffset, copyOffset, copySize));
            }
            this.baseOffset = (int)copyOffset;
            this.fromBase = copySize;
            return this.readNext();
        }
        if (command2 != 0) {
            this.fromDelta = command2 - 1;
            return this.delta.read();
        }
        throw new StreamCorruptedException(JGitText.get().unsupportedCommand0);
    }

    private int next(InputStream in) throws IOException {
        int b2 = in.read();
        if (b2 < 0) {
            throw new EOFException();
        }
        return b2;
    }

    private long readVarInt(InputStream in) throws IOException {
        int b2;
        long val = 0L;
        int shift = 0;
        do {
            b2 = this.next(in);
            val |= (long)(b2 & 0x7F) << shift;
            shift += 7;
        } while ((b2 & 0x80) != 0);
        return val;
    }

    public long getExpectedResultSize() throws IOException {
        if (this.baseOffset < 0) {
            this.initialize();
        }
        return this.resultLength;
    }

    public boolean isFullyConsumed() {
        try {
            return this.toDeliver == 0L && this.delta.read() < 0;
        }
        catch (IOException e2) {
            return this.toDeliver == 0L;
        }
    }

    @Override
    public void close() throws IOException {
        this.delta.close();
    }
}

