/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.InvalidMarkException;
import java.util.Objects;
import org.eclipse.jgit.annotations.NonNull;
import org.eclipse.jgit.internal.JGitText;

public class ByteBufferInputStream
extends InputStream {
    private ByteBuffer buf;

    public ByteBufferInputStream(@NonNull ByteBuffer buf) {
        this.buf = buf;
    }

    @Override
    public int read() throws IOException {
        this.nullCheck();
        if (this.buf.hasRemaining()) {
            return this.buf.get() & 0xFF;
        }
        return -1;
    }

    @Override
    public int read(byte[] b2) throws IOException {
        this.nullCheck();
        return this.read(b2, 0, b2.length);
    }

    @Override
    public int read(byte[] b2, int off, int len2) throws IOException {
        this.nullCheck();
        Objects.checkFromIndexSize(off, len2, b2.length);
        if (len2 == 0) {
            return 0;
        }
        int length = Math.min(this.buf.remaining(), len2);
        if (length == 0) {
            return -1;
        }
        this.buf.get(b2, off, length);
        return length;
    }

    @Override
    public byte[] readAllBytes() throws IOException {
        return this.readNBytes(this.buf.remaining());
    }

    @Override
    public byte[] readNBytes(int len2) throws IOException {
        int l = Math.min(len2, this.buf.remaining());
        byte[] b2 = new byte[l];
        this.read(b2);
        return b2;
    }

    @Override
    public int readNBytes(byte[] b2, int off, int len2) throws IOException {
        return this.read(b2, off, len2);
    }

    @Override
    public long skip(long n) throws IOException {
        this.nullCheck();
        if (n <= 0L) {
            return 0L;
        }
        int delta = n > Integer.MAX_VALUE ? this.buf.remaining() : Math.min((int)n, this.buf.remaining());
        this.buf.position(this.buf.position() + delta);
        return delta;
    }

    @Override
    public int available() throws IOException {
        this.nullCheck();
        return this.buf.remaining();
    }

    @Override
    public void close() {
        this.buf = null;
    }

    @Override
    public synchronized void mark(int readlimit) {
        this.buf.mark();
    }

    @Override
    public synchronized void reset() throws IOException {
        try {
            this.buf.reset();
        }
        catch (InvalidMarkException e2) {
            throw new IOException(e2);
        }
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    private void nullCheck() throws IOException {
        if (this.buf == null) {
            throw new IOException(JGitText.get().inputStreamClosed);
        }
    }
}

