/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import org.eclipse.jgit.attributes.Attributes;
import org.eclipse.jgit.lib.CoreConfig;
import org.eclipse.jgit.treewalk.TreeWalk;
import org.eclipse.jgit.treewalk.WorkingTreeOptions;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.io.AutoCRLFInputStream;
import org.eclipse.jgit.util.io.AutoCRLFOutputStream;
import org.eclipse.jgit.util.io.AutoLFInputStream;
import org.eclipse.jgit.util.io.AutoLFOutputStream;

public final class EolStreamTypeUtil {
    private EolStreamTypeUtil() {
    }

    public static CoreConfig.EolStreamType detectStreamType(TreeWalk.OperationType op, WorkingTreeOptions options2, Attributes attrs) {
        switch (op) {
            case CHECKIN_OP: {
                return EolStreamTypeUtil.checkInStreamType(options2, attrs);
            }
            case CHECKOUT_OP: {
                return EolStreamTypeUtil.checkOutStreamType(options2, attrs);
            }
        }
        throw new IllegalArgumentException("unknown OperationType " + String.valueOf((Object)op));
    }

    public static InputStream wrapInputStream(InputStream in, CoreConfig.EolStreamType conversion) {
        return EolStreamTypeUtil.wrapInputStream(in, conversion, false);
    }

    public static InputStream wrapInputStream(InputStream in, CoreConfig.EolStreamType conversion, boolean forCheckout) {
        switch (conversion) {
            case TEXT_CRLF: {
                return new AutoCRLFInputStream(in, false);
            }
            case TEXT_LF: {
                return AutoLFInputStream.create(in, new AutoLFInputStream.StreamFlag[0]);
            }
            case AUTO_CRLF: {
                return new AutoCRLFInputStream(in, true);
            }
            case AUTO_LF: {
                EnumSet<AutoLFInputStream.StreamFlag> flags = forCheckout ? EnumSet.of(AutoLFInputStream.StreamFlag.DETECT_BINARY, AutoLFInputStream.StreamFlag.FOR_CHECKOUT) : EnumSet.of(AutoLFInputStream.StreamFlag.DETECT_BINARY);
                return new AutoLFInputStream(in, flags);
            }
        }
        return in;
    }

    public static OutputStream wrapOutputStream(OutputStream out2, CoreConfig.EolStreamType conversion) {
        switch (conversion) {
            case TEXT_CRLF: {
                return new AutoCRLFOutputStream(out2, false);
            }
            case AUTO_CRLF: {
                return new AutoCRLFOutputStream(out2, true);
            }
            case TEXT_LF: {
                return new AutoLFOutputStream(out2, false);
            }
            case AUTO_LF: {
                return new AutoLFOutputStream(out2, true);
            }
        }
        return out2;
    }

    private static CoreConfig.EolStreamType checkInStreamType(WorkingTreeOptions options2, Attributes attrs) {
        if (attrs.isUnset("text")) {
            return CoreConfig.EolStreamType.DIRECT;
        }
        if (attrs.isSet("crlf")) {
            return CoreConfig.EolStreamType.TEXT_LF;
        }
        if (attrs.isUnset("crlf")) {
            return CoreConfig.EolStreamType.DIRECT;
        }
        if ("input".equals(attrs.getValue("crlf"))) {
            return CoreConfig.EolStreamType.TEXT_LF;
        }
        if ("auto".equals(attrs.getValue("text"))) {
            return CoreConfig.EolStreamType.AUTO_LF;
        }
        String eol = attrs.getValue("eol");
        if (eol != null) {
            return CoreConfig.EolStreamType.TEXT_LF;
        }
        if (attrs.isSet("text")) {
            return CoreConfig.EolStreamType.TEXT_LF;
        }
        switch (options2.getAutoCRLF()) {
            case TRUE: 
            case INPUT: {
                return CoreConfig.EolStreamType.AUTO_LF;
            }
            case FALSE: {
                return CoreConfig.EolStreamType.DIRECT;
            }
        }
        return CoreConfig.EolStreamType.DIRECT;
    }

    private static CoreConfig.EolStreamType getOutputFormat(WorkingTreeOptions options2) {
        switch (options2.getAutoCRLF()) {
            case TRUE: {
                return CoreConfig.EolStreamType.TEXT_CRLF;
            }
            case INPUT: {
                return CoreConfig.EolStreamType.DIRECT;
            }
        }
        switch (options2.getEOL()) {
            case CRLF: {
                return CoreConfig.EolStreamType.TEXT_CRLF;
            }
            case NATIVE: {
                if (SystemReader.getInstance().isWindows()) {
                    return CoreConfig.EolStreamType.TEXT_CRLF;
                }
                return CoreConfig.EolStreamType.TEXT_LF;
            }
        }
        return CoreConfig.EolStreamType.DIRECT;
    }

    private static CoreConfig.EolStreamType checkOutStreamType(WorkingTreeOptions options2, Attributes attrs) {
        if (attrs.isUnset("text")) {
            return CoreConfig.EolStreamType.DIRECT;
        }
        if (attrs.isSet("crlf")) {
            return EolStreamTypeUtil.getOutputFormat(options2);
        }
        if (attrs.isUnset("crlf")) {
            return CoreConfig.EolStreamType.DIRECT;
        }
        if ("input".equals(attrs.getValue("crlf"))) {
            return CoreConfig.EolStreamType.DIRECT;
        }
        String eol = attrs.getValue("eol");
        if (eol != null) {
            if ("crlf".equals(eol)) {
                if ("auto".equals(attrs.getValue("text"))) {
                    return CoreConfig.EolStreamType.AUTO_CRLF;
                }
                return CoreConfig.EolStreamType.TEXT_CRLF;
            }
            if ("lf".equals(eol)) {
                return CoreConfig.EolStreamType.DIRECT;
            }
        }
        if (attrs.isSet("text")) {
            return EolStreamTypeUtil.getOutputFormat(options2);
        }
        if ("auto".equals(attrs.getValue("text"))) {
            CoreConfig.EolStreamType basic = EolStreamTypeUtil.getOutputFormat(options2);
            switch (basic) {
                case TEXT_CRLF: {
                    return CoreConfig.EolStreamType.AUTO_CRLF;
                }
                case TEXT_LF: {
                    return CoreConfig.EolStreamType.AUTO_LF;
                }
            }
            return basic;
        }
        switch (options2.getAutoCRLF()) {
            case TRUE: {
                return CoreConfig.EolStreamType.AUTO_CRLF;
            }
        }
        return CoreConfig.EolStreamType.DIRECT;
    }
}

