/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.jgit.internal.JGitText;

public class IsolatedOutputStream
extends OutputStream {
    private final OutputStream dst;
    private final ExecutorService copier;
    private Future<Void> pending;

    public IsolatedOutputStream(OutputStream out2) {
        this.dst = out2;
        this.copier = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(1), new NamedThreadFactory());
    }

    @Override
    public void write(int ch) throws IOException {
        this.write(new byte[]{(byte)ch}, 0, 1);
    }

    @Override
    public void write(byte[] buf, int pos, int cnt) throws IOException {
        this.checkClosed();
        this.execute(() -> {
            this.dst.write(buf, pos, cnt);
            return null;
        });
    }

    @Override
    public void flush() throws IOException {
        this.checkClosed();
        this.execute(() -> {
            this.dst.flush();
            return null;
        });
    }

    @Override
    public void close() throws IOException {
        if (!this.copier.isShutdown()) {
            try {
                if (this.pending == null || this.tryCleanClose()) {
                    this.cleanClose();
                } else {
                    this.dirtyClose();
                }
            }
            finally {
                this.copier.shutdown();
            }
        }
    }

    private boolean tryCleanClose() {
        try {
            this.pending.get(0L, TimeUnit.MILLISECONDS);
            this.pending = null;
            return true;
        }
        catch (InterruptedException | TimeoutException e2) {
            return false;
        }
        catch (ExecutionException e3) {
            this.pending = null;
            return true;
        }
    }

    private void cleanClose() throws IOException {
        this.execute(() -> {
            this.dst.close();
            return null;
        });
    }

    private void dirtyClose() throws IOException {
        Future<Void> close2;
        this.pending.cancel(true);
        try {
            close2 = this.copier.submit(() -> {
                this.dst.close();
                return null;
            });
        }
        catch (RejectedExecutionException e2) {
            throw new IOException(e2);
        }
        try {
            close2.get(200L, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException | TimeoutException e3) {
            close2.cancel(true);
            throw new IOException(e3);
        }
        catch (ExecutionException e4) {
            throw new IOException(e4.getCause());
        }
    }

    private void checkClosed() throws IOException {
        if (this.copier.isShutdown()) {
            throw new IOException(JGitText.get().closed);
        }
    }

    private void execute(Callable<Void> task) throws IOException {
        if (this.pending != null) {
            IsolatedOutputStream.checkedGet(this.pending);
        }
        try {
            this.pending = this.copier.submit(task);
        }
        catch (RejectedExecutionException e2) {
            throw new IOException(e2);
        }
        IsolatedOutputStream.checkedGet(this.pending);
        this.pending = null;
    }

    private static void checkedGet(Future<Void> future) throws IOException {
        try {
            future.get();
        }
        catch (InterruptedException e2) {
            throw IsolatedOutputStream.interrupted(e2);
        }
        catch (ExecutionException e3) {
            throw new IOException(e3.getCause());
        }
    }

    private static InterruptedIOException interrupted(InterruptedException c2) {
        InterruptedIOException e2 = new InterruptedIOException();
        e2.initCause(c2);
        return e2;
    }

    private static class NamedThreadFactory
    implements ThreadFactory {
        private static final AtomicInteger cnt = new AtomicInteger();

        private NamedThreadFactory() {
        }

        @Override
        public Thread newThread(Runnable r) {
            int n = cnt.incrementAndGet();
            String name = IsolatedOutputStream.class.getSimpleName() + "-" + n;
            return new Thread(r, name);
        }
    }
}

