/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.IOException;
import java.io.Writer;
import org.eclipse.jgit.util.SystemReader;

public class ThrowingPrintWriter
extends Writer {
    private final Writer out;
    private final String LF;

    public ThrowingPrintWriter(Writer out2) {
        this.out = out2;
        this.LF = SystemReader.getInstance().getProperty("line.separator");
    }

    @Override
    public void write(char[] cbuf, int off, int len2) throws IOException {
        this.out.write(cbuf, off, len2);
    }

    @Override
    public void flush() throws IOException {
        this.out.flush();
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    public void println(String s2) throws IOException {
        this.print(s2 + this.LF);
    }

    public void println() throws IOException {
        this.print(this.LF);
    }

    public void print(char value2) throws IOException {
        this.print(String.valueOf(value2));
    }

    public void print(int value2) throws IOException {
        this.print(String.valueOf(value2));
    }

    public void print(long value2) throws IOException {
        this.print(String.valueOf(value2));
    }

    public void print(short value2) throws IOException {
        this.print(String.valueOf(value2));
    }

    public void format(String fmt, Object ... args2) throws IOException {
        this.print(String.format(fmt, args2));
    }

    public void print(Object any2) throws IOException {
        this.out.write(String.valueOf(any2));
    }
}

