/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.io;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.text.MessageFormat;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.util.io.InterruptTimer;

public class TimeoutOutputStream
extends OutputStream {
    private final OutputStream dst;
    private final InterruptTimer myTimer;
    private int timeout;

    public TimeoutOutputStream(OutputStream destination, InterruptTimer timer) {
        this.dst = destination;
        this.myTimer = timer;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int millis) {
        if (millis < 0) {
            throw new IllegalArgumentException(MessageFormat.format(JGitText.get().invalidTimeout, millis));
        }
        this.timeout = millis;
    }

    @Override
    public void write(int b2) throws IOException {
        try {
            try {
                this.beginWrite();
                this.dst.write(b2);
            }
            catch (InterruptedIOException e2) {
                throw this.writeTimedOut(e2);
            }
        }
        finally {
            this.endWrite();
        }
    }

    @Override
    public void write(byte[] buf) throws IOException {
        this.write(buf, 0, buf.length);
    }

    @Override
    public void write(byte[] buf, int off, int len2) throws IOException {
        try {
            try {
                this.beginWrite();
                this.dst.write(buf, off, len2);
            }
            catch (InterruptedIOException e2) {
                throw this.writeTimedOut(e2);
            }
        }
        finally {
            this.endWrite();
        }
    }

    @Override
    public void flush() throws IOException {
        try {
            try {
                this.beginWrite();
                this.dst.flush();
            }
            catch (InterruptedIOException e2) {
                throw this.writeTimedOut(e2);
            }
        }
        finally {
            this.endWrite();
        }
    }

    @Override
    public void close() throws IOException {
        try {
            try {
                this.beginWrite();
                this.dst.close();
            }
            catch (InterruptedIOException e2) {
                throw this.writeTimedOut(e2);
            }
        }
        finally {
            this.endWrite();
        }
    }

    private void beginWrite() {
        this.myTimer.begin(this.timeout);
    }

    private void endWrite() {
        this.myTimer.end();
    }

    private InterruptedIOException writeTimedOut(InterruptedIOException cause) {
        InterruptedIOException e2 = new InterruptedIOException(MessageFormat.format(JGitText.get().writeTimedOut, this.timeout));
        e2.initCause(cause);
        return e2;
    }
}

