/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.sha1;

import java.io.IOException;
import org.eclipse.jgit.errors.ConfigInvalidException;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.sha1.SHA1Java;
import org.eclipse.jgit.util.sha1.SHA1Native;
import org.eclipse.jgit.util.sha1.Sha1CollisionException;

public abstract class SHA1 {
    private static final Sha1Implementation SHA1_IMPLEMENTATION = SHA1.fromConfig();

    private static Sha1Implementation fromConfig() {
        try {
            return SystemReader.getInstance().getUserConfig().getEnum("core", null, "sha1implementation", Sha1Implementation.JAVA);
        }
        catch (IOException | ConfigInvalidException e2) {
            return Sha1Implementation.JAVA;
        }
    }

    private static Sha1Implementation getImplementation() {
        String fromSystemProperty = System.getProperty("org.eclipse.jgit.util.sha1.implementation");
        if (fromSystemProperty == null) {
            return SHA1_IMPLEMENTATION;
        }
        if (fromSystemProperty.equalsIgnoreCase(Sha1Implementation.JAVA.name())) {
            return Sha1Implementation.JAVA;
        }
        if (fromSystemProperty.equalsIgnoreCase(Sha1Implementation.JDKNATIVE.name())) {
            return Sha1Implementation.JDKNATIVE;
        }
        return SHA1_IMPLEMENTATION;
    }

    public static SHA1 newInstance() {
        if (SHA1.getImplementation() == Sha1Implementation.JDKNATIVE) {
            return new SHA1Native();
        }
        return new SHA1Java();
    }

    public abstract void update(byte var1);

    public abstract void update(byte[] var1);

    public abstract void update(byte[] var1, int var2, int var3);

    public abstract byte[] digest() throws Sha1CollisionException;

    public abstract ObjectId toObjectId() throws Sha1CollisionException;

    public abstract void digest(MutableObjectId var1) throws Sha1CollisionException;

    public abstract SHA1 reset();

    public abstract SHA1 setDetectCollision(boolean var1);

    public abstract boolean hasCollision();

    public static enum Sha1Implementation {
        JAVA(SHA1Java.class),
        JDKNATIVE(SHA1Native.class);

        private final String implClassName;

        private Sha1Implementation(Class implClass) {
            this.implClassName = implClass.getName();
        }

        public String toString() {
            return this.implClassName;
        }
    }
}

