/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.util.sha1;

import java.text.MessageFormat;
import java.util.Arrays;
import org.eclipse.jgit.internal.JGitText;
import org.eclipse.jgit.lib.MutableObjectId;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.util.NB;
import org.eclipse.jgit.util.SystemReader;
import org.eclipse.jgit.util.sha1.SHA1;
import org.eclipse.jgit.util.sha1.Sha1CollisionException;
import org.eclipse.jgit.util.sha1.UbcCheck;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SHA1Java
extends SHA1 {
    private static final Logger LOG = LoggerFactory.getLogger(SHA1Java.class);
    private static final boolean DETECT_COLLISIONS;
    private final State h = new State();
    private final int[] w = new int[80];
    private final byte[] buffer = new byte[64];
    private long length;
    private boolean detectCollision = DETECT_COLLISIONS;
    private boolean foundCollision;
    private final int[] w2 = new int[80];
    private final State state58 = new State();
    private final State state65 = new State();
    private final State hIn = new State();
    private final State hTmp = new State();

    static {
        SystemReader sr = SystemReader.getInstance();
        String v = sr.getProperty("org.eclipse.jgit.util.sha1.detectCollision");
        DETECT_COLLISIONS = v != null ? Boolean.parseBoolean(v) : true;
    }

    SHA1Java() {
        this.h.init();
    }

    @Override
    public SHA1 setDetectCollision(boolean detect) {
        this.detectCollision = detect;
        return this;
    }

    @Override
    public void update(byte b2) {
        int bufferLen = (int)(this.length & 0x3FL);
        ++this.length;
        this.buffer[bufferLen] = b2;
        if (bufferLen == 63) {
            this.compress(this.buffer, 0);
        }
    }

    @Override
    public void update(byte[] in) {
        this.update(in, 0, in.length);
    }

    @Override
    public void update(byte[] in, int p, int len2) {
        int bufferLen = (int)(this.length & 0x3FL);
        this.length += (long)len2;
        if (bufferLen > 0) {
            int n = Math.min(64 - bufferLen, len2);
            System.arraycopy(in, p, this.buffer, bufferLen, n);
            p += n;
            len2 -= n;
            if (bufferLen + n < 64) {
                return;
            }
            this.compress(this.buffer, 0);
        }
        while (len2 >= 64) {
            this.compress(in, p);
            p += 64;
            len2 -= 64;
        }
        if (len2 > 0) {
            System.arraycopy(in, p, this.buffer, 0, len2);
        }
    }

    private void compress(byte[] block2, int p) {
        this.initBlock(block2, p);
        int ubcDvMask = this.detectCollision ? UbcCheck.check(this.w) : 0;
        this.compress();
        while (ubcDvMask != 0) {
            int b2 = Integer.numberOfTrailingZeros(Integer.lowestOneBit(ubcDvMask));
            UbcCheck.DvInfo dv = UbcCheck.DV[b2];
            int i2 = 0;
            while (i2 < 80) {
                this.w2[i2] = this.w[i2] ^ dv.dm[i2];
                ++i2;
            }
            this.recompress(dv.testt);
            if (SHA1Java.eq(this.hTmp, this.h)) {
                this.foundCollision = true;
                break;
            }
            ubcDvMask &= ~(1 << b2);
        }
    }

    private void initBlock(byte[] block2, int p) {
        int t2 = 0;
        while (t2 < 16) {
            this.w[t2] = NB.decodeInt32(block2, p + (t2 << 2));
            ++t2;
        }
        t2 = 16;
        while (t2 < 80) {
            int x = this.w[t2 - 3] ^ this.w[t2 - 8] ^ this.w[t2 - 14] ^ this.w[t2 - 16];
            this.w[t2] = Integer.rotateLeft(x, 1);
            ++t2;
        }
    }

    private void compress() {
        int a2 = this.h.a;
        int b2 = this.h.b;
        int c2 = this.h.c;
        int d2 = this.h.d;
        int e2 = this.h.e;
        e2 += SHA1Java.s1(a2, b2, c2, d2, this.w[0]);
        b2 = Integer.rotateLeft(b2, 30);
        d2 += SHA1Java.s1(e2, a2, b2, c2, this.w[1]);
        a2 = Integer.rotateLeft(a2, 30);
        c2 += SHA1Java.s1(d2, e2, a2, b2, this.w[2]);
        e2 = Integer.rotateLeft(e2, 30);
        b2 += SHA1Java.s1(c2, d2, e2, a2, this.w[3]);
        d2 = Integer.rotateLeft(d2, 30);
        a2 += SHA1Java.s1(b2, c2, d2, e2, this.w[4]);
        c2 = Integer.rotateLeft(c2, 30);
        e2 += SHA1Java.s1(a2, b2, c2, d2, this.w[5]);
        b2 = Integer.rotateLeft(b2, 30);
        d2 += SHA1Java.s1(e2, a2, b2, c2, this.w[6]);
        a2 = Integer.rotateLeft(a2, 30);
        c2 += SHA1Java.s1(d2, e2, a2, b2, this.w[7]);
        e2 = Integer.rotateLeft(e2, 30);
        b2 += SHA1Java.s1(c2, d2, e2, a2, this.w[8]);
        d2 = Integer.rotateLeft(d2, 30);
        a2 += SHA1Java.s1(b2, c2, d2, e2, this.w[9]);
        c2 = Integer.rotateLeft(c2, 30);
        e2 += SHA1Java.s1(a2, b2, c2, d2, this.w[10]);
        b2 = Integer.rotateLeft(b2, 30);
        d2 += SHA1Java.s1(e2, a2, b2, c2, this.w[11]);
        a2 = Integer.rotateLeft(a2, 30);
        c2 += SHA1Java.s1(d2, e2, a2, b2, this.w[12]);
        e2 = Integer.rotateLeft(e2, 30);
        b2 += SHA1Java.s1(c2, d2, e2, a2, this.w[13]);
        d2 = Integer.rotateLeft(d2, 30);
        a2 += SHA1Java.s1(b2, c2, d2, e2, this.w[14]);
        c2 = Integer.rotateLeft(c2, 30);
        e2 += SHA1Java.s1(a2, b2, c2, d2, this.w[15]);
        b2 = Integer.rotateLeft(b2, 30);
        d2 += SHA1Java.s1(e2, a2, b2, c2, this.w[16]);
        a2 = Integer.rotateLeft(a2, 30);
        c2 += SHA1Java.s1(d2, e2, a2, b2, this.w[17]);
        e2 = Integer.rotateLeft(e2, 30);
        b2 += SHA1Java.s1(c2, d2, e2, a2, this.w[18]);
        d2 = Integer.rotateLeft(d2, 30);
        a2 += SHA1Java.s1(b2, c2, d2, e2, this.w[19]);
        c2 = Integer.rotateLeft(c2, 30);
        e2 += SHA1Java.s2(a2, b2, c2, d2, this.w[20]);
        b2 = Integer.rotateLeft(b2, 30);
        d2 += SHA1Java.s2(e2, a2, b2, c2, this.w[21]);
        a2 = Integer.rotateLeft(a2, 30);
        c2 += SHA1Java.s2(d2, e2, a2, b2, this.w[22]);
        e2 = Integer.rotateLeft(e2, 30);
        b2 += SHA1Java.s2(c2, d2, e2, a2, this.w[23]);
        d2 = Integer.rotateLeft(d2, 30);
        a2 += SHA1Java.s2(b2, c2, d2, e2, this.w[24]);
        c2 = Integer.rotateLeft(c2, 30);
        e2 += SHA1Java.s2(a2, b2, c2, d2, this.w[25]);
        b2 = Integer.rotateLeft(b2, 30);
        d2 += SHA1Java.s2(e2, a2, b2, c2, this.w[26]);
        a2 = Integer.rotateLeft(a2, 30);
        c2 += SHA1Java.s2(d2, e2, a2, b2, this.w[27]);
        e2 = Integer.rotateLeft(e2, 30);
        b2 += SHA1Java.s2(c2, d2, e2, a2, this.w[28]);
        d2 = Integer.rotateLeft(d2, 30);
        a2 += SHA1Java.s2(b2, c2, d2, e2, this.w[29]);
        c2 = Integer.rotateLeft(c2, 30);
        e2 += SHA1Java.s2(a2, b2, c2, d2, this.w[30]);
        b2 = Integer.rotateLeft(b2, 30);
        d2 += SHA1Java.s2(e2, a2, b2, c2, this.w[31]);
        a2 = Integer.rotateLeft(a2, 30);
        c2 += SHA1Java.s2(d2, e2, a2, b2, this.w[32]);
        e2 = Integer.rotateLeft(e2, 30);
        b2 += SHA1Java.s2(c2, d2, e2, a2, this.w[33]);
        d2 = Integer.rotateLeft(d2, 30);
        a2 += SHA1Java.s2(b2, c2, d2, e2, this.w[34]);
        c2 = Integer.rotateLeft(c2, 30);
        e2 += SHA1Java.s2(a2, b2, c2, d2, this.w[35]);
        b2 = Integer.rotateLeft(b2, 30);
        d2 += SHA1Java.s2(e2, a2, b2, c2, this.w[36]);
        a2 = Integer.rotateLeft(a2, 30);
        c2 += SHA1Java.s2(d2, e2, a2, b2, this.w[37]);
        e2 = Integer.rotateLeft(e2, 30);
        b2 += SHA1Java.s2(c2, d2, e2, a2, this.w[38]);
        d2 = Integer.rotateLeft(d2, 30);
        a2 += SHA1Java.s2(b2, c2, d2, e2, this.w[39]);
        c2 = Integer.rotateLeft(c2, 30);
        e2 += SHA1Java.s3(a2, b2, c2, d2, this.w[40]);
        b2 = Integer.rotateLeft(b2, 30);
        d2 += SHA1Java.s3(e2, a2, b2, c2, this.w[41]);
        a2 = Integer.rotateLeft(a2, 30);
        c2 += SHA1Java.s3(d2, e2, a2, b2, this.w[42]);
        e2 = Integer.rotateLeft(e2, 30);
        b2 += SHA1Java.s3(c2, d2, e2, a2, this.w[43]);
        d2 = Integer.rotateLeft(d2, 30);
        a2 += SHA1Java.s3(b2, c2, d2, e2, this.w[44]);
        c2 = Integer.rotateLeft(c2, 30);
        e2 += SHA1Java.s3(a2, b2, c2, d2, this.w[45]);
        b2 = Integer.rotateLeft(b2, 30);
        d2 += SHA1Java.s3(e2, a2, b2, c2, this.w[46]);
        a2 = Integer.rotateLeft(a2, 30);
        c2 += SHA1Java.s3(d2, e2, a2, b2, this.w[47]);
        e2 = Integer.rotateLeft(e2, 30);
        b2 += SHA1Java.s3(c2, d2, e2, a2, this.w[48]);
        d2 = Integer.rotateLeft(d2, 30);
        a2 += SHA1Java.s3(b2, c2, d2, e2, this.w[49]);
        c2 = Integer.rotateLeft(c2, 30);
        e2 += SHA1Java.s3(a2, b2, c2, d2, this.w[50]);
        b2 = Integer.rotateLeft(b2, 30);
        d2 += SHA1Java.s3(e2, a2, b2, c2, this.w[51]);
        a2 = Integer.rotateLeft(a2, 30);
        c2 += SHA1Java.s3(d2, e2, a2, b2, this.w[52]);
        e2 = Integer.rotateLeft(e2, 30);
        b2 += SHA1Java.s3(c2, d2, e2, a2, this.w[53]);
        d2 = Integer.rotateLeft(d2, 30);
        a2 += SHA1Java.s3(b2, c2, d2, e2, this.w[54]);
        c2 = Integer.rotateLeft(c2, 30);
        e2 += SHA1Java.s3(a2, b2, c2, d2, this.w[55]);
        b2 = Integer.rotateLeft(b2, 30);
        d2 += SHA1Java.s3(e2, a2, b2, c2, this.w[56]);
        a2 = Integer.rotateLeft(a2, 30);
        c2 += SHA1Java.s3(d2, e2, a2, b2, this.w[57]);
        e2 = Integer.rotateLeft(e2, 30);
        this.state58.save(a2, b2, c2, d2, e2);
        b2 += SHA1Java.s3(c2, d2, e2, a2, this.w[58]);
        d2 = Integer.rotateLeft(d2, 30);
        a2 += SHA1Java.s3(b2, c2, d2, e2, this.w[59]);
        c2 = Integer.rotateLeft(c2, 30);
        e2 += SHA1Java.s4(a2, b2, c2, d2, this.w[60]);
        b2 = Integer.rotateLeft(b2, 30);
        d2 += SHA1Java.s4(e2, a2, b2, c2, this.w[61]);
        a2 = Integer.rotateLeft(a2, 30);
        c2 += SHA1Java.s4(d2, e2, a2, b2, this.w[62]);
        e2 = Integer.rotateLeft(e2, 30);
        b2 += SHA1Java.s4(c2, d2, e2, a2, this.w[63]);
        d2 = Integer.rotateLeft(d2, 30);
        a2 += SHA1Java.s4(b2, c2, d2, e2, this.w[64]);
        c2 = Integer.rotateLeft(c2, 30);
        this.state65.save(a2, b2, c2, d2, e2);
        e2 += SHA1Java.s4(a2, b2, c2, d2, this.w[65]);
        b2 = Integer.rotateLeft(b2, 30);
        d2 += SHA1Java.s4(e2, a2, b2, c2, this.w[66]);
        a2 = Integer.rotateLeft(a2, 30);
        c2 += SHA1Java.s4(d2, e2, a2, b2, this.w[67]);
        e2 = Integer.rotateLeft(e2, 30);
        b2 += SHA1Java.s4(c2, d2, e2, a2, this.w[68]);
        d2 = Integer.rotateLeft(d2, 30);
        a2 += SHA1Java.s4(b2, c2, d2, e2, this.w[69]);
        c2 = Integer.rotateLeft(c2, 30);
        e2 += SHA1Java.s4(a2, b2, c2, d2, this.w[70]);
        b2 = Integer.rotateLeft(b2, 30);
        d2 += SHA1Java.s4(e2, a2, b2, c2, this.w[71]);
        a2 = Integer.rotateLeft(a2, 30);
        c2 += SHA1Java.s4(d2, e2, a2, b2, this.w[72]);
        e2 = Integer.rotateLeft(e2, 30);
        b2 += SHA1Java.s4(c2, d2, e2, a2, this.w[73]);
        d2 = Integer.rotateLeft(d2, 30);
        a2 += SHA1Java.s4(b2, c2, d2, e2, this.w[74]);
        c2 = Integer.rotateLeft(c2, 30);
        e2 += SHA1Java.s4(a2, b2, c2, d2, this.w[75]);
        b2 = Integer.rotateLeft(b2, 30);
        d2 += SHA1Java.s4(e2, a2, b2, c2, this.w[76]);
        a2 = Integer.rotateLeft(a2, 30);
        c2 += SHA1Java.s4(d2, e2, a2, b2, this.w[77]);
        e2 = Integer.rotateLeft(e2, 30);
        b2 += SHA1Java.s4(c2, d2, e2, a2, this.w[78]);
        d2 = Integer.rotateLeft(d2, 30);
        a2 += SHA1Java.s4(b2, c2, d2, e2, this.w[79]);
        c2 = Integer.rotateLeft(c2, 30);
        this.h.save(this.h.a + a2, this.h.b + b2, this.h.c + c2, this.h.d + d2, this.h.e + e2);
    }

    private void recompress(int t2) {
        State s2 = switch (t2) {
            case 58 -> this.state58;
            case 65 -> this.state65;
            default -> throw new IllegalStateException();
        };
        int a2 = s2.a;
        int b2 = s2.b;
        int c2 = s2.c;
        int d2 = s2.d;
        int e2 = s2.e;
        if (t2 == 65) {
            c2 = Integer.rotateRight(c2, 30);
            a2 -= SHA1Java.s4(b2, c2, d2, e2, this.w2[64]);
            d2 = Integer.rotateRight(d2, 30);
            b2 -= SHA1Java.s4(c2, d2, e2, a2, this.w2[63]);
            e2 = Integer.rotateRight(e2, 30);
            c2 -= SHA1Java.s4(d2, e2, a2, b2, this.w2[62]);
            a2 = Integer.rotateRight(a2, 30);
            d2 -= SHA1Java.s4(e2, a2, b2, c2, this.w2[61]);
            b2 = Integer.rotateRight(b2, 30);
            e2 -= SHA1Java.s4(a2, b2, c2, d2, this.w2[60]);
            c2 = Integer.rotateRight(c2, 30);
            a2 -= SHA1Java.s3(b2, c2, d2, e2, this.w2[59]);
            d2 = Integer.rotateRight(d2, 30);
            b2 -= SHA1Java.s3(c2, d2, e2, a2, this.w2[58]);
        }
        e2 = Integer.rotateRight(e2, 30);
        c2 -= SHA1Java.s3(d2, e2, a2, b2, this.w2[57]);
        a2 = Integer.rotateRight(a2, 30);
        d2 -= SHA1Java.s3(e2, a2, b2, c2, this.w2[56]);
        b2 = Integer.rotateRight(b2, 30);
        e2 -= SHA1Java.s3(a2, b2, c2, d2, this.w2[55]);
        c2 = Integer.rotateRight(c2, 30);
        a2 -= SHA1Java.s3(b2, c2, d2, e2, this.w2[54]);
        d2 = Integer.rotateRight(d2, 30);
        b2 -= SHA1Java.s3(c2, d2, e2, a2, this.w2[53]);
        e2 = Integer.rotateRight(e2, 30);
        c2 -= SHA1Java.s3(d2, e2, a2, b2, this.w2[52]);
        a2 = Integer.rotateRight(a2, 30);
        d2 -= SHA1Java.s3(e2, a2, b2, c2, this.w2[51]);
        b2 = Integer.rotateRight(b2, 30);
        e2 -= SHA1Java.s3(a2, b2, c2, d2, this.w2[50]);
        c2 = Integer.rotateRight(c2, 30);
        a2 -= SHA1Java.s3(b2, c2, d2, e2, this.w2[49]);
        d2 = Integer.rotateRight(d2, 30);
        b2 -= SHA1Java.s3(c2, d2, e2, a2, this.w2[48]);
        e2 = Integer.rotateRight(e2, 30);
        c2 -= SHA1Java.s3(d2, e2, a2, b2, this.w2[47]);
        a2 = Integer.rotateRight(a2, 30);
        d2 -= SHA1Java.s3(e2, a2, b2, c2, this.w2[46]);
        b2 = Integer.rotateRight(b2, 30);
        e2 -= SHA1Java.s3(a2, b2, c2, d2, this.w2[45]);
        c2 = Integer.rotateRight(c2, 30);
        a2 -= SHA1Java.s3(b2, c2, d2, e2, this.w2[44]);
        d2 = Integer.rotateRight(d2, 30);
        b2 -= SHA1Java.s3(c2, d2, e2, a2, this.w2[43]);
        e2 = Integer.rotateRight(e2, 30);
        c2 -= SHA1Java.s3(d2, e2, a2, b2, this.w2[42]);
        a2 = Integer.rotateRight(a2, 30);
        d2 -= SHA1Java.s3(e2, a2, b2, c2, this.w2[41]);
        b2 = Integer.rotateRight(b2, 30);
        e2 -= SHA1Java.s3(a2, b2, c2, d2, this.w2[40]);
        c2 = Integer.rotateRight(c2, 30);
        a2 -= SHA1Java.s2(b2, c2, d2, e2, this.w2[39]);
        d2 = Integer.rotateRight(d2, 30);
        b2 -= SHA1Java.s2(c2, d2, e2, a2, this.w2[38]);
        e2 = Integer.rotateRight(e2, 30);
        c2 -= SHA1Java.s2(d2, e2, a2, b2, this.w2[37]);
        a2 = Integer.rotateRight(a2, 30);
        d2 -= SHA1Java.s2(e2, a2, b2, c2, this.w2[36]);
        b2 = Integer.rotateRight(b2, 30);
        e2 -= SHA1Java.s2(a2, b2, c2, d2, this.w2[35]);
        c2 = Integer.rotateRight(c2, 30);
        a2 -= SHA1Java.s2(b2, c2, d2, e2, this.w2[34]);
        d2 = Integer.rotateRight(d2, 30);
        b2 -= SHA1Java.s2(c2, d2, e2, a2, this.w2[33]);
        e2 = Integer.rotateRight(e2, 30);
        c2 -= SHA1Java.s2(d2, e2, a2, b2, this.w2[32]);
        a2 = Integer.rotateRight(a2, 30);
        d2 -= SHA1Java.s2(e2, a2, b2, c2, this.w2[31]);
        b2 = Integer.rotateRight(b2, 30);
        e2 -= SHA1Java.s2(a2, b2, c2, d2, this.w2[30]);
        c2 = Integer.rotateRight(c2, 30);
        a2 -= SHA1Java.s2(b2, c2, d2, e2, this.w2[29]);
        d2 = Integer.rotateRight(d2, 30);
        b2 -= SHA1Java.s2(c2, d2, e2, a2, this.w2[28]);
        e2 = Integer.rotateRight(e2, 30);
        c2 -= SHA1Java.s2(d2, e2, a2, b2, this.w2[27]);
        a2 = Integer.rotateRight(a2, 30);
        d2 -= SHA1Java.s2(e2, a2, b2, c2, this.w2[26]);
        b2 = Integer.rotateRight(b2, 30);
        e2 -= SHA1Java.s2(a2, b2, c2, d2, this.w2[25]);
        c2 = Integer.rotateRight(c2, 30);
        a2 -= SHA1Java.s2(b2, c2, d2, e2, this.w2[24]);
        d2 = Integer.rotateRight(d2, 30);
        b2 -= SHA1Java.s2(c2, d2, e2, a2, this.w2[23]);
        e2 = Integer.rotateRight(e2, 30);
        c2 -= SHA1Java.s2(d2, e2, a2, b2, this.w2[22]);
        a2 = Integer.rotateRight(a2, 30);
        d2 -= SHA1Java.s2(e2, a2, b2, c2, this.w2[21]);
        b2 = Integer.rotateRight(b2, 30);
        e2 -= SHA1Java.s2(a2, b2, c2, d2, this.w2[20]);
        c2 = Integer.rotateRight(c2, 30);
        a2 -= SHA1Java.s1(b2, c2, d2, e2, this.w2[19]);
        d2 = Integer.rotateRight(d2, 30);
        b2 -= SHA1Java.s1(c2, d2, e2, a2, this.w2[18]);
        e2 = Integer.rotateRight(e2, 30);
        c2 -= SHA1Java.s1(d2, e2, a2, b2, this.w2[17]);
        a2 = Integer.rotateRight(a2, 30);
        d2 -= SHA1Java.s1(e2, a2, b2, c2, this.w2[16]);
        b2 = Integer.rotateRight(b2, 30);
        e2 -= SHA1Java.s1(a2, b2, c2, d2, this.w2[15]);
        c2 = Integer.rotateRight(c2, 30);
        a2 -= SHA1Java.s1(b2, c2, d2, e2, this.w2[14]);
        d2 = Integer.rotateRight(d2, 30);
        b2 -= SHA1Java.s1(c2, d2, e2, a2, this.w2[13]);
        e2 = Integer.rotateRight(e2, 30);
        c2 -= SHA1Java.s1(d2, e2, a2, b2, this.w2[12]);
        a2 = Integer.rotateRight(a2, 30);
        d2 -= SHA1Java.s1(e2, a2, b2, c2, this.w2[11]);
        b2 = Integer.rotateRight(b2, 30);
        e2 -= SHA1Java.s1(a2, b2, c2, d2, this.w2[10]);
        c2 = Integer.rotateRight(c2, 30);
        a2 -= SHA1Java.s1(b2, c2, d2, e2, this.w2[9]);
        d2 = Integer.rotateRight(d2, 30);
        b2 -= SHA1Java.s1(c2, d2, e2, a2, this.w2[8]);
        e2 = Integer.rotateRight(e2, 30);
        c2 -= SHA1Java.s1(d2, e2, a2, b2, this.w2[7]);
        a2 = Integer.rotateRight(a2, 30);
        d2 -= SHA1Java.s1(e2, a2, b2, c2, this.w2[6]);
        b2 = Integer.rotateRight(b2, 30);
        e2 -= SHA1Java.s1(a2, b2, c2, d2, this.w2[5]);
        c2 = Integer.rotateRight(c2, 30);
        a2 -= SHA1Java.s1(b2, c2, d2, e2, this.w2[4]);
        d2 = Integer.rotateRight(d2, 30);
        b2 -= SHA1Java.s1(c2, d2, e2, a2, this.w2[3]);
        e2 = Integer.rotateRight(e2, 30);
        c2 -= SHA1Java.s1(d2, e2, a2, b2, this.w2[2]);
        a2 = Integer.rotateRight(a2, 30);
        d2 -= SHA1Java.s1(e2, a2, b2, c2, this.w2[1]);
        b2 = Integer.rotateRight(b2, 30);
        this.hIn.save(a2, b2, c2, d2, e2 -= SHA1Java.s1(a2, b2, c2, d2, this.w2[0]));
        a2 = s2.a;
        b2 = s2.b;
        c2 = s2.c;
        d2 = s2.d;
        e2 = s2.e;
        if (t2 == 58) {
            b2 += SHA1Java.s3(c2, d2, e2, a2, this.w2[58]);
            d2 = Integer.rotateLeft(d2, 30);
            a2 += SHA1Java.s3(b2, c2, d2, e2, this.w2[59]);
            c2 = Integer.rotateLeft(c2, 30);
            e2 += SHA1Java.s4(a2, b2, c2, d2, this.w2[60]);
            b2 = Integer.rotateLeft(b2, 30);
            d2 += SHA1Java.s4(e2, a2, b2, c2, this.w2[61]);
            a2 = Integer.rotateLeft(a2, 30);
            c2 += SHA1Java.s4(d2, e2, a2, b2, this.w2[62]);
            e2 = Integer.rotateLeft(e2, 30);
            b2 += SHA1Java.s4(c2, d2, e2, a2, this.w2[63]);
            d2 = Integer.rotateLeft(d2, 30);
            a2 += SHA1Java.s4(b2, c2, d2, e2, this.w2[64]);
            c2 = Integer.rotateLeft(c2, 30);
        }
        e2 += SHA1Java.s4(a2, b2, c2, d2, this.w2[65]);
        b2 = Integer.rotateLeft(b2, 30);
        d2 += SHA1Java.s4(e2, a2, b2, c2, this.w2[66]);
        a2 = Integer.rotateLeft(a2, 30);
        c2 += SHA1Java.s4(d2, e2, a2, b2, this.w2[67]);
        e2 = Integer.rotateLeft(e2, 30);
        b2 += SHA1Java.s4(c2, d2, e2, a2, this.w2[68]);
        d2 = Integer.rotateLeft(d2, 30);
        a2 += SHA1Java.s4(b2, c2, d2, e2, this.w2[69]);
        c2 = Integer.rotateLeft(c2, 30);
        e2 += SHA1Java.s4(a2, b2, c2, d2, this.w2[70]);
        b2 = Integer.rotateLeft(b2, 30);
        d2 += SHA1Java.s4(e2, a2, b2, c2, this.w2[71]);
        a2 = Integer.rotateLeft(a2, 30);
        c2 += SHA1Java.s4(d2, e2, a2, b2, this.w2[72]);
        e2 = Integer.rotateLeft(e2, 30);
        b2 += SHA1Java.s4(c2, d2, e2, a2, this.w2[73]);
        d2 = Integer.rotateLeft(d2, 30);
        a2 += SHA1Java.s4(b2, c2, d2, e2, this.w2[74]);
        c2 = Integer.rotateLeft(c2, 30);
        e2 += SHA1Java.s4(a2, b2, c2, d2, this.w2[75]);
        b2 = Integer.rotateLeft(b2, 30);
        d2 += SHA1Java.s4(e2, a2, b2, c2, this.w2[76]);
        a2 = Integer.rotateLeft(a2, 30);
        c2 += SHA1Java.s4(d2, e2, a2, b2, this.w2[77]);
        e2 = Integer.rotateLeft(e2, 30);
        b2 += SHA1Java.s4(c2, d2, e2, a2, this.w2[78]);
        d2 = Integer.rotateLeft(d2, 30);
        a2 += SHA1Java.s4(b2, c2, d2, e2, this.w2[79]);
        c2 = Integer.rotateLeft(c2, 30);
        this.hTmp.save(this.hIn.a + a2, this.hIn.b + b2, this.hIn.c + c2, this.hIn.d + d2, this.hIn.e + e2);
    }

    private static int s1(int a2, int b2, int c2, int d2, int w_t) {
        return Integer.rotateLeft(a2, 5) + (b2 & c2 | ~b2 & d2) + 1518500249 + w_t;
    }

    private static int s2(int a2, int b2, int c2, int d2, int w_t) {
        return Integer.rotateLeft(a2, 5) + (b2 ^ c2 ^ d2) + 1859775393 + w_t;
    }

    private static int s3(int a2, int b2, int c2, int d2, int w_t) {
        return Integer.rotateLeft(a2, 5) + (b2 & c2 | b2 & d2 | c2 & d2) + -1894007588 + w_t;
    }

    private static int s4(int a2, int b2, int c2, int d2, int w_t) {
        return Integer.rotateLeft(a2, 5) + (b2 ^ c2 ^ d2) + -899497514 + w_t;
    }

    private static boolean eq(State q, State r) {
        return q.a == r.a && q.b == r.b && q.c == r.c && q.d == r.d && q.e == r.e;
    }

    private void finish() {
        int bufferLen = (int)(this.length & 0x3FL);
        if (bufferLen > 55) {
            this.buffer[bufferLen++] = -128;
            Arrays.fill(this.buffer, bufferLen, 64, (byte)0);
            this.compress(this.buffer, 0);
            Arrays.fill(this.buffer, 0, 56, (byte)0);
        } else {
            this.buffer[bufferLen++] = -128;
            Arrays.fill(this.buffer, bufferLen, 56, (byte)0);
        }
        NB.encodeInt32(this.buffer, 56, (int)(this.length >>> 29));
        NB.encodeInt32(this.buffer, 60, (int)(this.length << 3));
        this.compress(this.buffer, 0);
        if (this.foundCollision) {
            ObjectId id = this.h.toObjectId();
            LOG.warn(MessageFormat.format(JGitText.get().sha1CollisionDetected, id.name()));
            throw new Sha1CollisionException(id);
        }
    }

    @Override
    public byte[] digest() throws Sha1CollisionException {
        this.finish();
        byte[] b2 = new byte[20];
        NB.encodeInt32(b2, 0, this.h.a);
        NB.encodeInt32(b2, 4, this.h.b);
        NB.encodeInt32(b2, 8, this.h.c);
        NB.encodeInt32(b2, 12, this.h.d);
        NB.encodeInt32(b2, 16, this.h.e);
        return b2;
    }

    @Override
    public ObjectId toObjectId() throws Sha1CollisionException {
        this.finish();
        return this.h.toObjectId();
    }

    @Override
    public void digest(MutableObjectId id) throws Sha1CollisionException {
        this.finish();
        id.set(this.h.a, this.h.b, this.h.c, this.h.d, this.h.e);
    }

    @Override
    public boolean hasCollision() {
        return this.foundCollision;
    }

    @Override
    public SHA1 reset() {
        this.h.init();
        this.length = 0L;
        this.foundCollision = false;
        return this;
    }

    private static final class State {
        int a;
        int b;
        int c;
        int d;
        int e;

        private State() {
        }

        final void init() {
            this.save(1732584193, -271733879, -1732584194, 271733878, -1009589776);
        }

        final void save(int a1, int b1, int c1, int d1, int e1) {
            this.a = a1;
            this.b = b1;
            this.c = c1;
            this.d = d1;
            this.e = e1;
        }

        ObjectId toObjectId() {
            return new ObjectId(this.a, this.b, this.c, this.d, this.e);
        }
    }
}

