/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.support;

import java.net.URI;
import java.util.Objects;
import org.apiguardian.api.API;
import org.junit.platform.commons.support.Resource;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;

@API(status=API.Status.INTERNAL, since="1.12")
public class DefaultResource
implements Resource {
    private final String name;
    private final URI uri;

    public DefaultResource(String name, URI uri2) {
        this.name = Preconditions.notNull(name, "name must not be null");
        this.uri = Preconditions.notNull(uri2, "uri must not be null");
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public URI getUri() {
        return this.uri;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultResource that = (DefaultResource)o;
        return this.name.equals(that.name) && this.uri.equals(that.uri);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.uri);
    }

    public String toString() {
        return new ToStringBuilder(this).append("name", this.name).append("uri", this.uri).toString();
    }
}

