/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.support.conversion;

import org.junit.platform.commons.support.conversion.StringToObjectConverter;
import org.junit.platform.commons.util.Preconditions;

class StringToBooleanConverter
implements StringToObjectConverter {
    StringToBooleanConverter() {
    }

    @Override
    public boolean canConvertTo(Class<?> targetType) {
        return targetType == Boolean.class;
    }

    @Override
    public Object convert(String source2, Class<?> targetType) {
        boolean isTrue = "true".equalsIgnoreCase(source2);
        Preconditions.condition(isTrue || "false".equalsIgnoreCase(source2), () -> "String must be 'true' or 'false' (ignoring case): " + source2);
        return isTrue;
    }
}

