/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.support.scanning;

import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.MAINTAINED, since="1.13.3")
public class ClassFilter {
    private final Predicate<String> namePredicate;
    private final Predicate<Class<?>> classPredicate;

    public static ClassFilter of(Predicate<Class<?>> classPredicate) {
        return ClassFilter.of(name -> true, classPredicate);
    }

    public static ClassFilter of(Predicate<String> namePredicate, Predicate<Class<?>> classPredicate) {
        return new ClassFilter(namePredicate, classPredicate);
    }

    private ClassFilter(Predicate<String> namePredicate, Predicate<Class<?>> classPredicate) {
        this.namePredicate = Preconditions.notNull(namePredicate, "name predicate must not be null");
        this.classPredicate = Preconditions.notNull(classPredicate, "class predicate must not be null");
    }

    public boolean match(String name) {
        return this.namePredicate.test(name);
    }

    public boolean match(Class<?> type2) {
        return this.classPredicate.test(type2);
    }
}

