/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.support.scanning;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;

class ClasspathFileVisitor
extends SimpleFileVisitor<Path> {
    private static final Logger logger = LoggerFactory.getLogger(ClasspathFileVisitor.class);
    private final Path basePath;
    private final BiConsumer<Path, Path> consumer;
    private final Predicate<Path> filter;

    ClasspathFileVisitor(Path basePath, Predicate<Path> filter2, BiConsumer<Path, Path> consumer2) {
        this.basePath = basePath;
        this.filter = filter2;
        this.consumer = consumer2;
    }

    @Override
    public FileVisitResult visitFile(Path file2, BasicFileAttributes attributes2) {
        if (this.filter.test(file2)) {
            this.consumer.accept(this.basePath, file2);
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFileFailed(Path file2, IOException ex) {
        logger.warn(ex, () -> "I/O error visiting file: " + file2);
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult postVisitDirectory(Path dir, IOException ex) {
        if (ex != null) {
            logger.warn(ex, () -> "I/O error visiting directory: " + dir);
        }
        return FileVisitResult.CONTINUE;
    }
}

