/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.support.scanning;

import java.nio.file.Path;
import java.util.function.Predicate;

class ClasspathFilters {
    static final String CLASS_FILE_SUFFIX = ".class";
    private static final String PACKAGE_INFO_FILE_NAME = "package-info.class";
    private static final String MODULE_INFO_FILE_NAME = "module-info.class";

    ClasspathFilters() {
    }

    static Predicate<Path> classFiles() {
        return file2 -> ClasspathFilters.isNotPackageInfo(file2) && ClasspathFilters.isNotModuleInfo(file2) && ClasspathFilters.isClassFile(file2);
    }

    static Predicate<Path> resourceFiles() {
        return file2 -> !ClasspathFilters.isClassFile(file2);
    }

    private static boolean isNotPackageInfo(Path path2) {
        return !path2.endsWith(PACKAGE_INFO_FILE_NAME);
    }

    private static boolean isNotModuleInfo(Path path2) {
        return !path2.endsWith(MODULE_INFO_FILE_NAME);
    }

    private static boolean isClassFile(Path file2) {
        return file2.getFileName().toString().endsWith(CLASS_FILE_SUFFIX);
    }
}

