/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.support.scanning;

import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;

final class CloseablePath
implements Closeable {
    private static final String FILE_URI_SCHEME = "file";
    static final String JAR_URI_SCHEME = "jar";
    private static final String JAR_FILE_EXTENSION = ".jar";
    private static final String JAR_URI_SEPARATOR = "!/";
    private static final Closeable NULL_CLOSEABLE = () -> {};
    private static final ConcurrentMap<URI, ManagedFileSystem> MANAGED_FILE_SYSTEMS = new ConcurrentHashMap<URI, ManagedFileSystem>();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final Path path;
    private final Closeable delegate;

    static CloseablePath create(URI uri2) throws URISyntaxException {
        return CloseablePath.create(uri2, it -> FileSystems.newFileSystem(it, Collections.emptyMap()));
    }

    static CloseablePath create(URI uri2, FileSystemProvider fileSystemProvider) throws URISyntaxException {
        if (JAR_URI_SCHEME.equals(uri2.getScheme())) {
            String uriString = uri2.toString();
            int lastJarUriSeparator = uriString.lastIndexOf(JAR_URI_SEPARATOR);
            String jarUri = uriString.substring(0, lastJarUriSeparator);
            String jarEntry2 = uriString.substring(lastJarUriSeparator + 1);
            return CloseablePath.createForJarFileSystem(new URI(jarUri), fileSystem -> fileSystem.getPath(jarEntry2, new String[0]), fileSystemProvider);
        }
        if (FILE_URI_SCHEME.equals(uri2.getScheme()) && uri2.getPath().endsWith(JAR_FILE_EXTENSION)) {
            return CloseablePath.createForJarFileSystem(new URI("jar:" + uri2), fileSystem -> fileSystem.getRootDirectories().iterator().next(), fileSystemProvider);
        }
        return new CloseablePath(Paths.get(uri2), NULL_CLOSEABLE);
    }

    private static CloseablePath createForJarFileSystem(URI jarUri, Function<FileSystem, Path> pathProvider, FileSystemProvider fileSystemProvider) {
        ManagedFileSystem managedFileSystem = MANAGED_FILE_SYSTEMS.compute(jarUri, (__, oldValue) -> oldValue == null ? new ManagedFileSystem(jarUri, fileSystemProvider) : ((ManagedFileSystem)oldValue).retain());
        Path path2 = pathProvider.apply(managedFileSystem.fileSystem);
        return new CloseablePath(path2, () -> MANAGED_FILE_SYSTEMS.compute(jarUri, (__, ___) -> managedFileSystem.release()));
    }

    private CloseablePath(Path path2, Closeable delegate) {
        this.path = path2;
        this.delegate = delegate;
    }

    public Path getPath() {
        return this.path;
    }

    @Override
    public void close() throws IOException {
        if (this.closed.compareAndSet(false, true)) {
            this.delegate.close();
        }
    }

    static interface FileSystemProvider {
        public FileSystem newFileSystem(URI var1) throws IOException;
    }

    private static class ManagedFileSystem {
        private final AtomicInteger referenceCount = new AtomicInteger(1);
        private final FileSystem fileSystem;
        private final URI jarUri;

        ManagedFileSystem(URI jarUri, FileSystemProvider fileSystemProvider) {
            this.jarUri = jarUri;
            try {
                this.fileSystem = fileSystemProvider.newFileSystem(jarUri);
            }
            catch (IOException e2) {
                throw new UncheckedIOException("Failed to create file system for " + jarUri, e2);
            }
        }

        private ManagedFileSystem retain() {
            this.referenceCount.incrementAndGet();
            return this;
        }

        private ManagedFileSystem release() {
            if (this.referenceCount.decrementAndGet() == 0) {
                this.close();
                return null;
            }
            return this;
        }

        private void close() {
            try {
                this.fileSystem.close();
            }
            catch (IOException e2) {
                throw new UncheckedIOException("Failed to close file system for " + this.jarUri, e2);
            }
        }
    }
}

