/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.StringUtils;

@API(status=API.Status.INTERNAL, since="1.7")
public class ClassNamePatternFilterUtils {
    public static final String ALL_PATTERN = "*";
    public static final String BLANK = "";

    private ClassNamePatternFilterUtils() {
    }

    public static <T> Predicate<T> excludeMatchingClasses(String patterns2) {
        return ClassNamePatternFilterUtils.matchingClasses(patterns2, object -> object.getClass().getName(), FilterType.EXCLUDE);
    }

    public static Predicate<String> excludeMatchingClassNames(String patterns2) {
        return ClassNamePatternFilterUtils.matchingClasses(patterns2, Function.identity(), FilterType.EXCLUDE);
    }

    public static <T> Predicate<T> includeMatchingClasses(String patterns2) {
        return ClassNamePatternFilterUtils.matchingClasses(patterns2, object -> object.getClass().getName(), FilterType.INCLUDE);
    }

    public static Predicate<String> includeMatchingClassNames(String patterns2) {
        return ClassNamePatternFilterUtils.matchingClasses(patterns2, Function.identity(), FilterType.INCLUDE);
    }

    private static <T> Predicate<T> matchingClasses(String patterns2, Function<T, String> classNameProvider, FilterType type2) {
        return Optional.ofNullable(patterns2).filter(StringUtils::isNotBlank).map(String::trim).map(trimmedPatterns -> ClassNamePatternFilterUtils.createPredicateFromPatterns(trimmedPatterns, classNameProvider, type2)).orElse(type2 == FilterType.EXCLUDE ? __ -> true : __ -> false);
    }

    private static <T> Predicate<T> createPredicateFromPatterns(String patterns2, Function<T, String> classNameProvider, FilterType type2) {
        if (ALL_PATTERN.equals(patterns2)) {
            return type2 == FilterType.INCLUDE ? __ -> true : __ -> false;
        }
        List<Pattern> patternList = ClassNamePatternFilterUtils.convertToRegularExpressions(patterns2);
        return object -> {
            boolean isMatchingAnyPattern = patternList.stream().anyMatch(pattern2 -> pattern2.matcher((CharSequence)classNameProvider.apply(object)).matches());
            return type2 == FilterType.INCLUDE == isMatchingAnyPattern;
        };
    }

    private static List<Pattern> convertToRegularExpressions(String patterns2) {
        return Arrays.stream(patterns2.split(",")).filter(StringUtils::isNotBlank).map(String::trim).map(ClassNamePatternFilterUtils::replaceRegExElements).map(Pattern::compile).collect(Collectors.toList());
    }

    private static String replaceRegExElements(String pattern2) {
        return Matcher.quoteReplacement(pattern2).replace(".", "[.$]").replace(ALL_PATTERN, ".+");
    }

    private static enum FilterType {
        INCLUDE,
        EXCLUDE;

    }
}

