/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apiguardian.api.API;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.Preconditions;

@API(status=API.Status.INTERNAL, since="1.0")
public final class CollectionUtils {
    private CollectionUtils() {
    }

    public static <T> T getOnlyElement(Collection<T> collection) {
        Preconditions.notNull(collection, "collection must not be null");
        Preconditions.condition(collection.size() == 1, () -> "collection must contain exactly one element: " + collection);
        return CollectionUtils.firstElement(collection);
    }

    @API(status=API.Status.INTERNAL, since="1.11")
    public static <T> Optional<T> getFirstElement(Collection<T> collection) {
        Preconditions.notNull(collection, "collection must not be null");
        return collection.isEmpty() ? Optional.empty() : Optional.ofNullable(CollectionUtils.firstElement(collection));
    }

    private static <T> T firstElement(Collection<T> collection) {
        return (T)(collection instanceof List ? ((List)collection).get(0) : collection.iterator().next());
    }

    @API(status=API.Status.INTERNAL, since="1.6")
    public static <T> Set<T> toSet(T[] values2) {
        Preconditions.notNull(values2, "values array must not be null");
        if (values2.length == 0) {
            return Collections.emptySet();
        }
        if (values2.length == 1) {
            return Collections.singleton(values2[0]);
        }
        HashSet set2 = new HashSet();
        Collections.addAll(set2, values2);
        return set2;
    }

    public static <T> Collector<T, ?, List<T>> toUnmodifiableList() {
        return Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList);
    }

    @API(status=API.Status.INTERNAL, since="1.9.1")
    public static boolean isConvertibleToStream(Class<?> type2) {
        if (type2 == null || type2 == Void.TYPE) {
            return false;
        }
        return Stream.class.isAssignableFrom(type2) || DoubleStream.class.isAssignableFrom(type2) || IntStream.class.isAssignableFrom(type2) || LongStream.class.isAssignableFrom(type2) || Iterable.class.isAssignableFrom(type2) || Iterator.class.isAssignableFrom(type2) || Object[].class.isAssignableFrom(type2) || type2.isArray() && type2.getComponentType().isPrimitive() || CollectionUtils.findIteratorMethod(type2).isPresent();
    }

    public static Stream<?> toStream(Object object) {
        Preconditions.notNull(object, "Object must not be null");
        if (object instanceof Stream) {
            return (Stream)object;
        }
        if (object instanceof DoubleStream) {
            return ((DoubleStream)object).boxed();
        }
        if (object instanceof IntStream) {
            return ((IntStream)object).boxed();
        }
        if (object instanceof LongStream) {
            return ((LongStream)object).boxed();
        }
        if (object instanceof Collection) {
            return ((Collection)object).stream();
        }
        if (object instanceof Iterable) {
            return StreamSupport.stream(((Iterable)object).spliterator(), false);
        }
        if (object instanceof Iterator) {
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize((Iterator)object, 16), false);
        }
        if (object instanceof Object[]) {
            return Arrays.stream((Object[])object);
        }
        if (object instanceof double[]) {
            return DoubleStream.of((double[])object).boxed();
        }
        if (object instanceof int[]) {
            return IntStream.of((int[])object).boxed();
        }
        if (object instanceof long[]) {
            return LongStream.of((long[])object).boxed();
        }
        if (object.getClass().isArray() && object.getClass().getComponentType().isPrimitive()) {
            return IntStream.range(0, Array.getLength(object)).mapToObj(i2 -> Array.get(object, i2));
        }
        return CollectionUtils.tryConvertToStreamByReflection(object);
    }

    private static Stream<?> tryConvertToStreamByReflection(Object object) {
        return CollectionUtils.findIteratorMethod(object.getClass()).map(method2 -> (Iterator)ReflectionSupport.invokeMethod(method2, object, new Object[0])).map(iterator2 -> Spliterators.spliteratorUnknownSize(iterator2, 16)).map(spliterator -> StreamSupport.stream(spliterator, false)).orElseThrow(() -> new PreconditionViolationException(String.format("Cannot convert instance of %s into a Stream: %s", object.getClass().getName(), object)));
    }

    private static Optional<Method> findIteratorMethod(Class<?> type2) {
        return ReflectionSupport.findMethod(type2, "iterator", new Class[0]).filter(method2 -> method2.getReturnType() == Iterator.class);
    }

    @API(status=API.Status.INTERNAL, since="1.9.2")
    public static <T> void forEachInReverseOrder(List<T> list, Consumer<? super T> action) {
        if (list.isEmpty()) {
            return;
        }
        if (list.size() == 1) {
            action.accept(list.get(0));
            return;
        }
        ListIterator<T> iterator2 = list.listIterator(list.size());
        while (iterator2.hasPrevious()) {
            action.accept(iterator2.previous());
        }
    }
}

