/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.util.ArrayList;
import java.util.List;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.StringUtils;

@API(status=API.Status.INTERNAL, since="1.0")
public class ToStringBuilder {
    private final String typeName;
    private final List<String> values = new ArrayList<String>();

    public ToStringBuilder(Object obj) {
        this(Preconditions.notNull(obj, "Object must not be null").getClass().getSimpleName());
    }

    public ToStringBuilder(Class<?> type2) {
        this(Preconditions.notNull(type2, "Class must not be null").getSimpleName());
    }

    @API(status=API.Status.INTERNAL, since="1.7")
    public ToStringBuilder(String typeName2) {
        this.typeName = Preconditions.notNull(typeName2, "Type name must not be null");
    }

    public ToStringBuilder append(String name, Object value2) {
        Preconditions.notBlank(name, "Name must not be null or blank");
        this.values.add(name + " = " + this.toString(value2));
        return this;
    }

    private String toString(Object obj) {
        return obj instanceof CharSequence ? "'" + obj + "'" : StringUtils.nullSafeToString(obj);
    }

    public String toString() {
        return this.typeName + " [" + String.join((CharSequence)", ", this.values) + "]";
    }
}

