/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine;

import java.util.Arrays;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestDescriptor;

final class CompositeTestDescriptorVisitor
implements TestDescriptor.Visitor {
    private final TestDescriptor.Visitor[] visitors;

    static TestDescriptor.Visitor from(TestDescriptor.Visitor ... visitors) {
        Preconditions.notNull(visitors, "visitors must not be null");
        Preconditions.notEmpty(visitors, "visitors must not be empty");
        Preconditions.containsNoNullElements(visitors, "visitors must not contain any null elements");
        return visitors.length == 1 ? visitors[0] : new CompositeTestDescriptorVisitor(visitors);
    }

    private CompositeTestDescriptorVisitor(TestDescriptor.Visitor[] visitors) {
        this.visitors = Arrays.copyOf(visitors, visitors.length);
    }

    @Override
    public void visit(TestDescriptor descriptor2) {
        for (TestDescriptor.Visitor visitor2 : this.visitors) {
            visitor2.visit(descriptor2);
        }
    }
}

