/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine;

import java.util.Objects;
import java.util.Optional;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.TestSource;

final class DefaultDiscoveryIssue
implements DiscoveryIssue {
    private final DiscoveryIssue.Severity severity;
    private final String message;
    private final TestSource source;
    private final Throwable cause;

    DefaultDiscoveryIssue(Builder builder) {
        this.severity = builder.severity;
        this.message = builder.message;
        this.source = builder.source;
        this.cause = builder.cause;
    }

    @Override
    public DiscoveryIssue.Severity severity() {
        return this.severity;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public Optional<TestSource> source() {
        return Optional.ofNullable(this.source);
    }

    @Override
    public Optional<Throwable> cause() {
        return Optional.ofNullable(this.cause);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultDiscoveryIssue that = (DefaultDiscoveryIssue)o;
        return this.severity == that.severity && Objects.equals(this.message, that.message) && Objects.equals(this.source, that.source) && Objects.equals(this.cause, that.cause);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.severity, this.message, this.source, this.cause});
    }

    public String toString() {
        ToStringBuilder builder = new ToStringBuilder(DiscoveryIssue.class.getSimpleName()).append("severity", (Object)this.severity).append("message", this.message);
        if (this.source != null) {
            builder.append("source", this.source);
        }
        if (this.cause != null) {
            builder.append("cause", this.cause);
        }
        return builder.toString();
    }

    static class Builder
    implements DiscoveryIssue.Builder {
        private final DiscoveryIssue.Severity severity;
        private final String message;
        private TestSource source;
        public Throwable cause;

        Builder(DiscoveryIssue.Severity severity, String message) {
            this.severity = severity;
            this.message = message;
        }

        @Override
        public Builder source(TestSource source2) {
            this.source = source2;
            return this;
        }

        @Override
        public Builder cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public DiscoveryIssue build() {
            return new DefaultDiscoveryIssue(this);
        }
    }
}

