/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine;

import java.io.Serializable;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.UniqueIdFormat;

@API(status=API.Status.STABLE, since="1.0")
public class UniqueId
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ENGINE_SEGMENT_TYPE = "engine";
    private final UniqueIdFormat uniqueIdFormat;
    private final List<Segment> segments;
    private transient int hashCode;
    private transient SoftReference<String> toString;

    public static UniqueId parse(String uniqueId) throws JUnitException {
        Preconditions.notBlank(uniqueId, "Unique ID string must not be null or blank");
        return UniqueIdFormat.getDefault().parse(uniqueId);
    }

    public static UniqueId forEngine(String engineId) {
        Preconditions.notBlank(engineId, "engineId must not be null or blank");
        return UniqueId.root(ENGINE_SEGMENT_TYPE, engineId);
    }

    public static UniqueId root(String segmentType, String value2) {
        return new UniqueId(UniqueIdFormat.getDefault(), new Segment(segmentType, value2));
    }

    private UniqueId(UniqueIdFormat uniqueIdFormat, Segment segment) {
        this(uniqueIdFormat, Collections.singletonList(segment));
    }

    UniqueId(UniqueIdFormat uniqueIdFormat, List<Segment> segments2) {
        this.uniqueIdFormat = uniqueIdFormat;
        this.segments = segments2;
    }

    final Optional<Segment> getRoot() {
        return this.segments.isEmpty() ? Optional.empty() : Optional.of(this.segments.get(0));
    }

    public final Optional<String> getEngineId() {
        return this.getRoot().filter(segment -> ENGINE_SEGMENT_TYPE.equals(segment.getType())).map(Segment::getValue);
    }

    public final List<Segment> getSegments() {
        return Collections.unmodifiableList(this.segments);
    }

    public final UniqueId append(String segmentType, String value2) {
        return this.append(new Segment(segmentType, value2));
    }

    @API(status=API.Status.STABLE, since="1.1")
    public final UniqueId append(Segment segment) {
        Preconditions.notNull(segment, "segment must not be null");
        ArrayList<Segment> baseSegments = new ArrayList<Segment>(this.segments.size() + 1);
        baseSegments.addAll(this.segments);
        baseSegments.add(segment);
        return new UniqueId(this.uniqueIdFormat, baseSegments);
    }

    @API(status=API.Status.STABLE, since="1.10")
    public UniqueId appendEngine(String engineId) {
        return this.append(new Segment(ENGINE_SEGMENT_TYPE, engineId));
    }

    @API(status=API.Status.STABLE, since="1.1")
    public boolean hasPrefix(UniqueId potentialPrefix) {
        Preconditions.notNull(potentialPrefix, "potentialPrefix must not be null");
        int size2 = this.segments.size();
        int prefixSize = potentialPrefix.segments.size();
        return size2 >= prefixSize && this.segments.subList(0, prefixSize).equals(potentialPrefix.segments);
    }

    @API(status=API.Status.STABLE, since="1.5")
    public UniqueId removeLastSegment() {
        Preconditions.condition(this.segments.size() > 1, "Cannot remove last remaining segment");
        return new UniqueId(this.uniqueIdFormat, new ArrayList<Segment>(this.segments.subList(0, this.segments.size() - 1)));
    }

    @API(status=API.Status.STABLE, since="1.5")
    public Segment getLastSegment() {
        return this.segments.get(this.segments.size() - 1);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UniqueId that = (UniqueId)o;
        return this.segments.equals(that.segments);
    }

    public int hashCode() {
        int value2 = this.hashCode;
        if (value2 == 0) {
            value2 = this.segments.hashCode();
            if (value2 == 0) {
                value2 = 1;
            }
            this.hashCode = value2;
        }
        return value2;
    }

    public String toString() {
        String value2;
        SoftReference<String> s2 = this.toString;
        String string = value2 = s2 == null ? null : s2.get();
        if (value2 == null) {
            value2 = this.uniqueIdFormat.format(this);
            this.toString = new SoftReference<String>(value2);
        }
        return value2;
    }

    @API(status=API.Status.STABLE, since="1.0")
    public static class Segment
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String type;
        private final String value;

        Segment(String type2, String value2) {
            Preconditions.notBlank(type2, "type must not be null or blank");
            Preconditions.notBlank(value2, "value must not be null or blank");
            this.type = type2;
            this.value = value2;
        }

        public String getType() {
            return this.type;
        }

        public String getValue() {
            return this.value;
        }

        public int hashCode() {
            return Objects.hash(this.type, this.value);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Segment that = (Segment)o;
            return Objects.equals(this.type, that.type) && Objects.equals(this.value, that.value);
        }

        public String toString() {
            return new ToStringBuilder(this).append("type", this.type).append("value", this.value).toString();
        }
    }
}

