/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.discovery.ClassNameFilter;

abstract class AbstractClassNameFilter
implements ClassNameFilter {
    protected final List<Pattern> patterns;
    protected final String patternDescription;

    AbstractClassNameFilter(String ... patterns2) {
        Preconditions.notEmpty(patterns2, "patterns array must not be null or empty");
        Preconditions.containsNoNullElements(patterns2, "patterns array must not contain null elements");
        this.patterns = Arrays.stream(patterns2).map(Pattern::compile).collect(Collectors.toList());
        this.patternDescription = Arrays.stream(patterns2).collect(Collectors.joining("' OR '", "'", "'"));
    }

    @Override
    public abstract Predicate<String> toPredicate();

    protected Optional<Pattern> findMatchingPattern(String className) {
        return this.patterns.stream().filter(pattern2 -> pattern2.matcher(className).matches()).findAny();
    }
}

