/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.discovery;

import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.discovery.AbstractClassNameFilter;

class IncludeClassNameFilter
extends AbstractClassNameFilter {
    IncludeClassNameFilter(String ... patterns2) {
        super(patterns2);
    }

    @Override
    public FilterResult apply(String className) {
        return this.findMatchingPattern(className).map(pattern2 -> FilterResult.included(this.formatInclusionReason(className, (Pattern)pattern2))).orElseGet(() -> FilterResult.excluded(this.formatExclusionReason(className)));
    }

    private String formatInclusionReason(String className, Pattern pattern2) {
        return String.format("Class name [%s] matches included pattern: '%s'", className, pattern2);
    }

    private String formatExclusionReason(String className) {
        return String.format("Class name [%s] does not match any included pattern: %s", className, this.patternDescription);
    }

    @Override
    public Predicate<String> toPredicate() {
        return className -> this.findMatchingPattern((String)className).isPresent();
    }

    public String toString() {
        return String.format("%s that includes class names that match one of the following regular expressions: %s", this.getClass().getSimpleName(), this.patternDescription);
    }
}

