/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.discovery;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.platform.commons.support.Resource;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.DiscoveryFilter;
import org.junit.platform.engine.EngineDiscoveryRequest;
import org.junit.platform.engine.Filter;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.discovery.ClassNameFilter;
import org.junit.platform.engine.discovery.PackageNameFilter;
import org.junit.platform.engine.support.discovery.ClassContainerSelectorResolver;
import org.junit.platform.engine.support.discovery.DiscoveryIssueReporter;
import org.junit.platform.engine.support.discovery.EngineDiscoveryRequestResolution;
import org.junit.platform.engine.support.discovery.ResourceContainerSelectorResolver;
import org.junit.platform.engine.support.discovery.SelectorResolver;

@API(status=API.Status.STABLE, since="1.10")
public class EngineDiscoveryRequestResolver<T extends TestDescriptor> {
    private final List<Function<InitializationContext<T>, SelectorResolver>> resolverCreators;
    private final List<Function<InitializationContext<T>, TestDescriptor.Visitor>> visitorCreators;

    private EngineDiscoveryRequestResolver(List<Function<InitializationContext<T>, SelectorResolver>> resolverCreators, List<Function<InitializationContext<T>, TestDescriptor.Visitor>> visitorCreators) {
        this.resolverCreators = new ArrayList<Function<InitializationContext<T>, SelectorResolver>>(resolverCreators);
        this.visitorCreators = new ArrayList<Function<InitializationContext<T>, TestDescriptor.Visitor>>(visitorCreators);
    }

    public void resolve(EngineDiscoveryRequest request2, T engineDescriptor) {
        Preconditions.notNull(request2, "request must not be null");
        Preconditions.notNull(engineDescriptor, "engineDescriptor must not be null");
        DiscoveryIssueReporter issueReporter = DiscoveryIssueReporter.forwarding(request2.getDiscoveryListener(), engineDescriptor.getUniqueId());
        this.resolve(request2, engineDescriptor, issueReporter);
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public void resolve(EngineDiscoveryRequest request2, T engineDescriptor, DiscoveryIssueReporter issueReporter) {
        Preconditions.notNull(request2, "request must not be null");
        Preconditions.notNull(engineDescriptor, "engineDescriptor must not be null");
        Preconditions.notNull(issueReporter, "issueReporter must not be null");
        DefaultInitializationContext<T> initializationContext = new DefaultInitializationContext<T>(request2, engineDescriptor, issueReporter);
        List<SelectorResolver> resolvers = this.instantiate(this.resolverCreators, initializationContext);
        List<TestDescriptor.Visitor> visitors = this.instantiate(this.visitorCreators, initializationContext);
        new EngineDiscoveryRequestResolution(request2, (TestDescriptor)engineDescriptor, resolvers, visitors).run();
    }

    private <R> List<R> instantiate(List<Function<InitializationContext<T>, R>> creators, InitializationContext<T> context) {
        return creators.stream().map(creator -> creator.apply(context)).collect(Collectors.toCollection(ArrayList::new));
    }

    public static <T extends TestDescriptor> Builder<T> builder() {
        return new Builder();
    }

    private static class DefaultInitializationContext<T extends TestDescriptor>
    implements InitializationContext<T> {
        private final EngineDiscoveryRequest request;
        private final T engineDescriptor;
        private final Predicate<String> classNameFilter;
        private final Predicate<String> packageFilter;
        private final DiscoveryIssueReporter issueReporter;

        DefaultInitializationContext(EngineDiscoveryRequest request2, T engineDescriptor, DiscoveryIssueReporter issueReporter) {
            this.request = request2;
            this.engineDescriptor = engineDescriptor;
            this.classNameFilter = this.buildClassNamePredicate(request2);
            this.packageFilter = this.buildPackagePredicate(request2);
            this.issueReporter = issueReporter;
        }

        private Predicate<String> buildClassNamePredicate(EngineDiscoveryRequest request2) {
            ArrayList<DiscoveryFilter<String>> filters = new ArrayList<DiscoveryFilter<String>>();
            filters.addAll(request2.getFiltersByType(ClassNameFilter.class));
            filters.addAll(request2.getFiltersByType(PackageNameFilter.class));
            return Filter.composeFilters(filters).toPredicate();
        }

        private Predicate<String> buildPackagePredicate(EngineDiscoveryRequest request2) {
            ArrayList<PackageNameFilter> filters = new ArrayList<PackageNameFilter>();
            filters.addAll(request2.getFiltersByType(PackageNameFilter.class));
            return Filter.composeFilters(filters).toPredicate();
        }

        @Override
        public EngineDiscoveryRequest getDiscoveryRequest() {
            return this.request;
        }

        @Override
        public T getEngineDescriptor() {
            return this.engineDescriptor;
        }

        @Override
        public Predicate<String> getClassNameFilter() {
            return this.classNameFilter;
        }

        @Override
        public Predicate<String> getPackageFilter() {
            return this.packageFilter;
        }

        @Override
        public DiscoveryIssueReporter getIssueReporter() {
            return this.issueReporter;
        }
    }

    @API(status=API.Status.STABLE, since="1.10")
    public static interface InitializationContext<T extends TestDescriptor> {
        public EngineDiscoveryRequest getDiscoveryRequest();

        public T getEngineDescriptor();

        public Predicate<String> getClassNameFilter();

        @API(status=API.Status.MAINTAINED, since="1.13.3")
        public Predicate<String> getPackageFilter();

        @API(status=API.Status.MAINTAINED, since="1.13.3")
        public DiscoveryIssueReporter getIssueReporter();
    }

    @API(status=API.Status.STABLE, since="1.10")
    public static class Builder<T extends TestDescriptor> {
        private final List<Function<InitializationContext<T>, SelectorResolver>> resolverCreators = new ArrayList<Function<InitializationContext<T>, SelectorResolver>>();
        private final List<Function<InitializationContext<T>, TestDescriptor.Visitor>> visitorCreators = new ArrayList<Function<InitializationContext<T>, TestDescriptor.Visitor>>();

        private Builder() {
        }

        public Builder<T> addClassContainerSelectorResolver(Predicate<Class<?>> classFilter) {
            Preconditions.notNull(classFilter, "classFilter must not be null");
            return this.addClassContainerSelectorResolverWithContext(__ -> classFilter);
        }

        @API(status=API.Status.MAINTAINED, since="1.13.3")
        public Builder<T> addClassContainerSelectorResolverWithContext(Function<InitializationContext<T>, Predicate<Class<?>>> classFilterCreator) {
            Preconditions.notNull(classFilterCreator, "classFilterCreator must not be null");
            return this.addSelectorResolver((InitializationContext<T> context) -> new ClassContainerSelectorResolver((Predicate)classFilterCreator.apply((InitializationContext)context), context.getClassNameFilter()));
        }

        @API(status=API.Status.MAINTAINED, since="1.13.3")
        public Builder<T> addResourceContainerSelectorResolver(Predicate<Resource> resourceFilter) {
            Preconditions.notNull(resourceFilter, "resourceFilter must not be null");
            return this.addSelectorResolver((InitializationContext<T> context) -> new ResourceContainerSelectorResolver(resourceFilter, context.getPackageFilter()));
        }

        public Builder<T> addSelectorResolver(SelectorResolver resolver) {
            Preconditions.notNull(resolver, "resolver must not be null");
            return this.addSelectorResolver((InitializationContext<T> context) -> resolver);
        }

        public Builder<T> addSelectorResolver(Function<InitializationContext<T>, SelectorResolver> resolverCreator) {
            this.resolverCreators.add(resolverCreator);
            return this;
        }

        public Builder<T> addTestDescriptorVisitor(Function<InitializationContext<T>, TestDescriptor.Visitor> visitorCreator) {
            this.visitorCreators.add(visitorCreator);
            return this;
        }

        public EngineDiscoveryRequestResolver<T> build() {
            return new EngineDiscoveryRequestResolver(this.resolverCreators, this.visitorCreators);
        }
    }
}

