/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.discovery;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.support.Resource;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.discovery.ClasspathRootSelector;
import org.junit.platform.engine.discovery.DiscoverySelectors;
import org.junit.platform.engine.discovery.ModuleSelector;
import org.junit.platform.engine.discovery.PackageSelector;
import org.junit.platform.engine.support.discovery.ResourceUtils;
import org.junit.platform.engine.support.discovery.SelectorResolver;

class ResourceContainerSelectorResolver
implements SelectorResolver {
    private final Predicate<Resource> resourceFilter;

    ResourceContainerSelectorResolver(Predicate<Resource> resourceFilter, Predicate<String> packageFilter) {
        this.resourceFilter = ResourceUtils.packageName(packageFilter).and(resourceFilter);
    }

    @Override
    public SelectorResolver.Resolution resolve(ClasspathRootSelector selector, SelectorResolver.Context context) {
        return this.resourceSelectors(ReflectionSupport.findAllResourcesInClasspathRoot(selector.getClasspathRoot(), this.resourceFilter));
    }

    @Override
    public SelectorResolver.Resolution resolve(ModuleSelector selector, SelectorResolver.Context context) {
        return this.resourceSelectors(ReflectionUtils.findAllResourcesInModule(selector.getModuleName(), this.resourceFilter));
    }

    @Override
    public SelectorResolver.Resolution resolve(PackageSelector selector, SelectorResolver.Context context) {
        return this.resourceSelectors(ReflectionSupport.findAllResourcesInPackage(selector.getPackageName(), this.resourceFilter));
    }

    private SelectorResolver.Resolution resourceSelectors(List<Resource> resources2) {
        Set selectors = resources2.stream().collect(Collectors.groupingBy(Resource::getName)).values().stream().map(LinkedHashSet::new).map(DiscoverySelectors::selectClasspathResource).collect(Collectors.toSet());
        if (selectors.isEmpty()) {
            return SelectorResolver.Resolution.unresolved();
        }
        return SelectorResolver.Resolution.selectors(selectors);
    }
}

