/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.Comparator;
import java.util.Objects;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;

@API(status=API.Status.STABLE, since="1.10")
public class ExclusiveResource {
    @API(status=API.Status.STABLE, since="1.10")
    public static final String GLOBAL_KEY = "org.junit.platform.engine.support.hierarchical.ExclusiveResource.GLOBAL_KEY";
    static final ExclusiveResource GLOBAL_READ = new ExclusiveResource("org.junit.platform.engine.support.hierarchical.ExclusiveResource.GLOBAL_KEY", LockMode.READ);
    static final ExclusiveResource GLOBAL_READ_WRITE = new ExclusiveResource("org.junit.platform.engine.support.hierarchical.ExclusiveResource.GLOBAL_KEY", LockMode.READ_WRITE);
    static final Comparator<ExclusiveResource> COMPARATOR = Comparator.comparing(ExclusiveResource::getKey, ExclusiveResource.globalKeyFirst().thenComparing(Comparator.naturalOrder())).thenComparing(ExclusiveResource::getLockMode);
    private final String key;
    private final LockMode lockMode;
    private int hash;

    private static Comparator<String> globalKeyFirst() {
        return Comparator.comparing(key2 -> !GLOBAL_KEY.equals(key2));
    }

    public ExclusiveResource(String key2, LockMode lockMode) {
        this.key = Preconditions.notBlank(key2, "key must not be blank");
        this.lockMode = Preconditions.notNull(lockMode, "lockMode must not be null");
    }

    public String getKey() {
        return this.key;
    }

    public LockMode getLockMode() {
        return this.lockMode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExclusiveResource that = (ExclusiveResource)o;
        return Objects.equals(this.key, that.key) && this.lockMode == that.lockMode;
    }

    public int hashCode() {
        int h2 = this.hash;
        if (h2 == 0) {
            h2 = this.hash = Objects.hash(new Object[]{this.key, this.lockMode});
        }
        return h2;
    }

    public String toString() {
        return new ToStringBuilder(this).append("key", this.key).append("lockMode", (Object)this.lockMode).toString();
    }

    public static enum LockMode {
        READ_WRITE,
        READ;

    }
}

