/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.hierarchical;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.engine.support.hierarchical.CompositeLock;
import org.junit.platform.engine.support.hierarchical.ExclusiveResource;
import org.junit.platform.engine.support.hierarchical.NopLock;
import org.junit.platform.engine.support.hierarchical.ResourceLock;
import org.junit.platform.engine.support.hierarchical.SingleLock;

class LockManager {
    private final Map<String, ReadWriteLock> locksByKey = new ConcurrentHashMap<String, ReadWriteLock>();
    private final SingleLock globalReadLock = new SingleLock(ExclusiveResource.GLOBAL_READ, this.toLock(ExclusiveResource.GLOBAL_READ));
    private final SingleLock globalReadWriteLock = new SingleLock(ExclusiveResource.GLOBAL_READ_WRITE, this.toLock(ExclusiveResource.GLOBAL_READ_WRITE));

    ResourceLock getLockForResources(Collection<ExclusiveResource> resources2) {
        return this.toResourceLock(this.toDistinctSortedResources(resources2));
    }

    ResourceLock getLockForResource(ExclusiveResource resource2) {
        return this.toResourceLock(Collections.singletonList(resource2));
    }

    private List<ExclusiveResource> toDistinctSortedResources(Collection<ExclusiveResource> resources2) {
        if (resources2.isEmpty()) {
            return Collections.emptyList();
        }
        if (resources2.size() == 1) {
            return Collections.singletonList(CollectionUtils.getOnlyElement(resources2));
        }
        Map resourcesByKey = resources2.stream().sorted(ExclusiveResource.COMPARATOR).distinct().collect(Collectors.groupingBy(ExclusiveResource::getKey, LinkedHashMap::new, Collectors.toList()));
        return resourcesByKey.values().stream().map(resourcesWithSameKey -> (ExclusiveResource)resourcesWithSameKey.get(0)).collect(CollectionUtils.toUnmodifiableList());
    }

    private ResourceLock toResourceLock(List<ExclusiveResource> resources2) {
        switch (resources2.size()) {
            case 0: {
                return NopLock.INSTANCE;
            }
            case 1: {
                return this.toSingleLock(CollectionUtils.getOnlyElement(resources2));
            }
        }
        return new CompositeLock(resources2, this.toLocks(resources2));
    }

    private SingleLock toSingleLock(ExclusiveResource resource2) {
        if (ExclusiveResource.GLOBAL_READ.equals(resource2)) {
            return this.globalReadLock;
        }
        if (ExclusiveResource.GLOBAL_READ_WRITE.equals(resource2)) {
            return this.globalReadWriteLock;
        }
        return new SingleLock(resource2, this.toLock(resource2));
    }

    private List<Lock> toLocks(List<ExclusiveResource> resources2) {
        return resources2.stream().map(this::toLock).collect(CollectionUtils.toUnmodifiableList());
    }

    private Lock toLock(ExclusiveResource resource2) {
        ReadWriteLock lock = this.locksByKey.computeIfAbsent(resource2.getKey(), key2 -> new ReentrantReadWriteLock());
        return resource2.getLockMode() == ExclusiveResource.LockMode.READ ? lock.readLock() : lock.writeLock();
    }
}

