/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.engine.support.store;

import java.util.Comparator;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.function.Supplier;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.ExceptionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.commons.util.UnrecoverableExceptions;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStoreException;

@API(status=API.Status.MAINTAINED, since="1.13.3")
public final class NamespacedHierarchicalStore<N>
implements AutoCloseable {
    private final AtomicInteger insertOrderSequence = new AtomicInteger();
    private final ConcurrentMap<CompositeKey<N>, StoredValue> storedValues = new ConcurrentHashMap<CompositeKey<N>, StoredValue>(4);
    private final NamespacedHierarchicalStore<N> parentStore;
    private final CloseAction<N> closeAction;
    private volatile boolean closed = false;

    public NamespacedHierarchicalStore(NamespacedHierarchicalStore<N> parentStore) {
        this(parentStore, null);
    }

    public NamespacedHierarchicalStore(NamespacedHierarchicalStore<N> parentStore, CloseAction<N> closeAction) {
        this.parentStore = parentStore;
        this.closeAction = closeAction;
    }

    public NamespacedHierarchicalStore<N> newChild() {
        return new NamespacedHierarchicalStore<N>(this, this.closeAction);
    }

    @API(status=API.Status.MAINTAINED, since="5.13.3")
    public Optional<NamespacedHierarchicalStore<N>> getParent() {
        return Optional.ofNullable(this.parentStore);
    }

    @API(status=API.Status.MAINTAINED, since="1.13.3")
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void close() {
        if (!this.closed) {
            try {
                if (this.closeAction != null) {
                    ThrowableCollector throwableCollector = new ThrowableCollector(__ -> false);
                    this.storedValues.entrySet().stream().map(e2 -> ((StoredValue)e2.getValue()).evaluateSafely((CompositeKey)e2.getKey())).filter(it -> it != null && ((EvaluatedValue)it).value != null).sorted(EvaluatedValue.REVERSE_INSERT_ORDER).forEach(it -> throwableCollector.execute(() -> ((EvaluatedValue)it).close(this.closeAction)));
                    throwableCollector.assertEmpty();
                }
            }
            finally {
                this.closed = true;
            }
        }
    }

    public Object get(N namespace, Object key2) {
        StoredValue storedValue = this.getStoredValue(new CompositeKey(namespace, key2));
        return StoredValue.evaluateIfNotNull(storedValue);
    }

    public <T> T get(N namespace, Object key2, Class<T> requiredType) throws NamespacedHierarchicalStoreException {
        Object value2 = this.get(namespace, key2);
        return this.castToRequiredType(key2, value2, requiredType);
    }

    public <K, V> Object getOrComputeIfAbsent(N namespace, K key2, Function<K, V> defaultCreator) {
        Preconditions.notNull(defaultCreator, "defaultCreator must not be null");
        CompositeKey compositeKey = new CompositeKey(namespace, key2);
        StoredValue storedValue = this.getStoredValue(compositeKey);
        if (storedValue == null) {
            storedValue = this.storedValues.computeIfAbsent(compositeKey, __ -> this.storedValue(new MemoizingSupplier(() -> {
                this.rejectIfClosed();
                return defaultCreator.apply(key2);
            })));
        }
        return storedValue.evaluate();
    }

    public <K, V> V getOrComputeIfAbsent(N namespace, K key2, Function<K, V> defaultCreator, Class<V> requiredType) throws NamespacedHierarchicalStoreException {
        Object value2 = this.getOrComputeIfAbsent(namespace, key2, defaultCreator);
        return this.castToRequiredType(key2, value2, requiredType);
    }

    public Object put(N namespace, Object key2, Object value2) throws NamespacedHierarchicalStoreException {
        this.rejectIfClosed();
        StoredValue oldValue = this.storedValues.put(new CompositeKey(namespace, key2), this.storedValue(() -> value2));
        return StoredValue.evaluateIfNotNull(oldValue);
    }

    public Object remove(N namespace, Object key2) {
        this.rejectIfClosed();
        StoredValue previous = (StoredValue)this.storedValues.remove(new CompositeKey(namespace, key2));
        return StoredValue.evaluateIfNotNull(previous);
    }

    public <T> T remove(N namespace, Object key2, Class<T> requiredType) throws NamespacedHierarchicalStoreException {
        this.rejectIfClosed();
        Object value2 = this.remove(namespace, key2);
        return this.castToRequiredType(key2, value2, requiredType);
    }

    private StoredValue storedValue(Supplier<Object> value2) {
        return new StoredValue(this.insertOrderSequence.getAndIncrement(), value2);
    }

    private StoredValue getStoredValue(CompositeKey<N> compositeKey) {
        StoredValue storedValue = (StoredValue)this.storedValues.get(compositeKey);
        if (storedValue != null) {
            return storedValue;
        }
        if (this.parentStore != null) {
            return super.getStoredValue(compositeKey);
        }
        return null;
    }

    private <T> T castToRequiredType(Object key2, Object value2, Class<T> requiredType) {
        Preconditions.notNull(requiredType, "requiredType must not be null");
        if (value2 == null) {
            return null;
        }
        if (ReflectionUtils.isAssignableTo(value2, requiredType)) {
            if (requiredType.isPrimitive()) {
                return (T)ReflectionUtils.getWrapperType(requiredType).cast(value2);
            }
            return requiredType.cast(value2);
        }
        throw new NamespacedHierarchicalStoreException(String.format("Object stored under key [%s] is not of required type [%s], but was [%s]: %s", key2, requiredType.getName(), value2.getClass().getName(), value2));
    }

    private void rejectIfClosed() {
        if (this.closed) {
            throw new NamespacedHierarchicalStoreException("A NamespacedHierarchicalStore cannot be modified or queried after it has been closed");
        }
    }

    @FunctionalInterface
    public static interface CloseAction<N> {
        @API(status=API.Status.MAINTAINED, since="1.13.3")
        public static <N> CloseAction<N> closeAutoCloseables() {
            return (__, ___, value2) -> {
                if (value2 instanceof AutoCloseable) {
                    ((AutoCloseable)value2).close();
                }
            };
        }

        public void close(N var1, Object var2, Object var3) throws Throwable;
    }

    private static class EvaluatedValue<N> {
        private static final Comparator<EvaluatedValue<?>> REVERSE_INSERT_ORDER = Comparator.comparing(it -> it.order).reversed();
        private final CompositeKey<N> compositeKey;
        private final int order;
        private final Object value;

        private EvaluatedValue(CompositeKey<N> compositeKey, int order, Object value2) {
            this.compositeKey = compositeKey;
            this.order = order;
            this.value = value2;
        }

        private void close(CloseAction<N> closeAction) throws Throwable {
            closeAction.close(((CompositeKey)this.compositeKey).namespace, ((CompositeKey)this.compositeKey).key, this.value);
        }
    }

    private static class CompositeKey<N> {
        private final N namespace;
        private final Object key;

        private CompositeKey(N namespace, Object key2) {
            this.namespace = Preconditions.notNull(namespace, "namespace must not be null");
            this.key = Preconditions.notNull(key2, "key must not be null");
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CompositeKey that = (CompositeKey)o;
            return this.namespace.equals(that.namespace) && this.key.equals(that.key);
        }

        public int hashCode() {
            return Objects.hash(this.namespace, this.key);
        }
    }

    private static class StoredValue {
        private final int order;
        private final Supplier<Object> supplier;

        StoredValue(int order, Supplier<Object> supplier) {
            this.order = order;
            this.supplier = supplier;
        }

        private <N> EvaluatedValue<N> evaluateSafely(CompositeKey<N> compositeKey) {
            try {
                return new EvaluatedValue(compositeKey, this.order, this.evaluate());
            }
            catch (Throwable t2) {
                UnrecoverableExceptions.rethrowIfUnrecoverable(t2);
                return null;
            }
        }

        private Object evaluate() {
            return this.supplier.get();
        }

        static Object evaluateIfNotNull(StoredValue value2) {
            return value2 != null ? value2.evaluate() : null;
        }
    }

    private static class MemoizingSupplier
    implements Supplier<Object> {
        private static final Object NO_VALUE_SET = new Object();
        private final Supplier<Object> delegate;
        private volatile Object value = NO_VALUE_SET;

        private MemoizingSupplier(Supplier<Object> delegate) {
            this.delegate = delegate;
        }

        @Override
        public Object get() {
            if (this.value == NO_VALUE_SET) {
                this.computeValue();
            }
            if (this.value instanceof Failure) {
                throw ExceptionUtils.throwAsUncheckedException(((Failure)this.value).throwable);
            }
            return this.value;
        }

        private synchronized void computeValue() {
            try {
                if (this.value == NO_VALUE_SET) {
                    this.value = this.delegate.get();
                }
            }
            catch (Throwable t2) {
                this.value = new Failure(t2);
                UnrecoverableExceptions.rethrowIfUnrecoverable(t2);
            }
        }

        private static class Failure {
            private final Throwable throwable;

            public Failure(Throwable throwable) {
                this.throwable = throwable;
            }
        }
    }
}

