/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.support.descriptor.MethodSource;
import org.junit.platform.launcher.MethodFilter;

abstract class AbstractMethodFilter
implements MethodFilter {
    protected final List<Pattern> patterns;
    protected final String patternDescription;

    AbstractMethodFilter(String ... patterns2) {
        Preconditions.notEmpty(patterns2, "patterns array must not be null or empty");
        Preconditions.containsNoNullElements(patterns2, "patterns array must not contain null elements");
        this.patterns = Arrays.stream(patterns2).map(Pattern::compile).collect(Collectors.toList());
        this.patternDescription = Arrays.stream(patterns2).collect(Collectors.joining("' OR '", "'", "'"));
    }

    protected Optional<Pattern> findMatchingPattern(String methodName) {
        if (methodName == null) {
            return Optional.empty();
        }
        return this.patterns.stream().filter(pattern2 -> pattern2.matcher(methodName).matches()).findAny();
    }

    protected String getFullyQualifiedMethodNameFromDescriptor(TestDescriptor descriptor2) {
        return descriptor2.getSource().filter(source2 -> source2 instanceof MethodSource).map(methodSource -> this.getFullyQualifiedMethodNameWithoutParameters((MethodSource)methodSource)).orElse(null);
    }

    private String getFullyQualifiedMethodNameWithoutParameters(MethodSource methodSource) {
        String methodNameWithParentheses = ReflectionUtils.getFullyQualifiedMethodName(methodSource.getJavaClass(), methodSource.getMethodName(), (Class[])null);
        return methodNameWithParentheses.substring(0, methodNameWithParentheses.length() - 2);
    }
}

