/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher;

import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.ToStringBuilder;

@API(status=API.Status.STABLE, since="1.10")
public class EngineDiscoveryResult {
    private static final EngineDiscoveryResult SUCCESSFUL_RESULT = new EngineDiscoveryResult(Status.SUCCESSFUL, null);
    private final Status status;
    private final Throwable throwable;

    public static EngineDiscoveryResult successful() {
        return SUCCESSFUL_RESULT;
    }

    public static EngineDiscoveryResult failed(Throwable throwable) {
        return new EngineDiscoveryResult(Status.FAILED, throwable);
    }

    private EngineDiscoveryResult(Status status2, Throwable throwable) {
        this.status = status2;
        this.throwable = throwable;
    }

    public Status getStatus() {
        return this.status;
    }

    public Optional<Throwable> getThrowable() {
        return Optional.ofNullable(this.throwable);
    }

    public String toString() {
        return new ToStringBuilder(this).append("status", (Object)this.status).append("throwable", this.throwable).toString();
    }

    public static enum Status {
        SUCCESSFUL,
        FAILED;

    }
}

