/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher;

import java.util.regex.Pattern;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.launcher.AbstractMethodFilter;

class IncludeMethodFilter
extends AbstractMethodFilter {
    IncludeMethodFilter(String ... patterns2) {
        super(patterns2);
    }

    @Override
    public FilterResult apply(TestDescriptor descriptor2) {
        String methodName = this.getFullyQualifiedMethodNameFromDescriptor(descriptor2);
        return this.findMatchingPattern(methodName).map(pattern2 -> FilterResult.included(this.formatInclusionReason(methodName, (Pattern)pattern2))).orElseGet(() -> FilterResult.excluded(this.formatExclusionReason(methodName)));
    }

    private String formatInclusionReason(String methodName, Pattern pattern2) {
        return String.format("Method name [%s] matches included pattern: '%s'", methodName, pattern2);
    }

    private String formatExclusionReason(String methodName) {
        return String.format("Method name [%s] does not match any included pattern: %s", methodName, this.patternDescription);
    }

    public String toString() {
        return String.format("%s that includes method names that match one of the following regular expressions: %s", this.getClass().getSimpleName(), this.patternDescription);
    }
}

