/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher;

import java.util.Arrays;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.FilterResult;
import org.junit.platform.engine.TestTag;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.tagexpression.TagExpression;

@API(status=API.Status.STABLE, since="1.0")
public final class TagFilter {
    private TagFilter() {
    }

    public static PostDiscoveryFilter includeTags(String ... tagExpressions) throws PreconditionViolationException {
        Preconditions.notNull(tagExpressions, "array of tag expressions must not be null");
        return TagFilter.includeTags(Arrays.asList(tagExpressions));
    }

    public static PostDiscoveryFilter includeTags(List<String> tagExpressions) throws PreconditionViolationException {
        Preconditions.notEmpty(tagExpressions, "list of tag expressions must not be null or empty");
        return TagFilter.includeMatching(tagExpressions);
    }

    public static PostDiscoveryFilter excludeTags(String ... tagExpressions) throws PreconditionViolationException {
        Preconditions.notNull(tagExpressions, "array of tag expressions must not be null");
        return TagFilter.excludeTags(Arrays.asList(tagExpressions));
    }

    public static PostDiscoveryFilter excludeTags(List<String> tagExpressions) throws PreconditionViolationException {
        Preconditions.notEmpty(tagExpressions, "list of tag expressions must not be null or empty");
        return TagFilter.excludeMatching(tagExpressions);
    }

    private static PostDiscoveryFilter includeMatching(List<String> tagExpressions) {
        Supplier<String> inclusionReason = () -> TagFilter.inclusionReasonExpressionSatisfy(tagExpressions);
        Supplier<String> exclusionReason = () -> TagFilter.exclusionReasonExpressionNotSatisfy(tagExpressions);
        List<TagExpression> parsedTagExpressions = TagFilter.parseAll(tagExpressions);
        return descriptor2 -> {
            Set<TestTag> tags = descriptor2.getTags();
            boolean included = parsedTagExpressions.stream().anyMatch(expression -> expression.evaluate(tags));
            return FilterResult.includedIf(included, inclusionReason, exclusionReason);
        };
    }

    private static String inclusionReasonExpressionSatisfy(List<String> tagExpressions) {
        return String.format("included because tags match expression(s): [%s]", TagFilter.formatToString(tagExpressions));
    }

    private static String exclusionReasonExpressionNotSatisfy(List<String> tagExpressions) {
        return String.format("excluded because tags do not match tag expression(s): [%s]", TagFilter.formatToString(tagExpressions));
    }

    private static PostDiscoveryFilter excludeMatching(List<String> tagExpressions) {
        Supplier<String> inclusionReason = () -> TagFilter.inclusionReasonExpressionNotSatisfy(tagExpressions);
        Supplier<String> exclusionReason = () -> TagFilter.exclusionReasonExpressionSatisfy(tagExpressions);
        List<TagExpression> parsedTagExpressions = TagFilter.parseAll(tagExpressions);
        return descriptor2 -> {
            Set<TestTag> tags = descriptor2.getTags();
            boolean included = parsedTagExpressions.stream().noneMatch(expression -> expression.evaluate(tags));
            return FilterResult.includedIf(included, inclusionReason, exclusionReason);
        };
    }

    private static String inclusionReasonExpressionNotSatisfy(List<String> tagExpressions) {
        return String.format("included because tags do not match expression(s): [%s]", TagFilter.formatToString(tagExpressions));
    }

    private static String exclusionReasonExpressionSatisfy(List<String> tagExpressions) {
        return String.format("excluded because tags match tag expression(s): [%s]", TagFilter.formatToString(tagExpressions));
    }

    private static String formatToString(List<String> tagExpressions) {
        return tagExpressions.stream().map(String::trim).sorted().collect(Collectors.joining(","));
    }

    private static List<TagExpression> parseAll(List<String> tagExpressions) {
        return tagExpressions.stream().map(TagFilter::parse).collect(CollectionUtils.toUnmodifiableList());
    }

    private static TagExpression parse(String tagExpression) {
        return TagExpression.parseFrom(tagExpression).tagExpressionOrThrow(message -> new PreconditionViolationException("Unable to parse tag expression \"" + tagExpression + "\": " + message));
    }
}

