/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestSource;
import org.junit.platform.engine.TestTag;
import org.junit.platform.engine.UniqueId;

@API(status=API.Status.STABLE, since="1.0")
public final class TestIdentifier
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final ObjectStreamField[] serialPersistentFields = ObjectStreamClass.lookup(SerializedForm.class).getFields();
    private UniqueId uniqueId;
    private UniqueId parentId;
    private String displayName;
    private String legacyReportingName;
    private TestSource source;
    private Set<TestTag> tags;
    private TestDescriptor.Type type;

    @API(status=API.Status.INTERNAL, since="1.0")
    public static TestIdentifier from(TestDescriptor testDescriptor) {
        Preconditions.notNull(testDescriptor, "TestDescriptor must not be null");
        UniqueId uniqueId = testDescriptor.getUniqueId();
        String displayName = testDescriptor.getDisplayName();
        TestSource source2 = testDescriptor.getSource().orElse(null);
        Set<TestTag> tags = testDescriptor.getTags();
        TestDescriptor.Type type2 = testDescriptor.getType();
        UniqueId parentId = testDescriptor.getParent().map(TestDescriptor::getUniqueId).orElse(null);
        String legacyReportingName = testDescriptor.getLegacyReportingName();
        return new TestIdentifier(uniqueId, displayName, source2, tags, type2, parentId, legacyReportingName);
    }

    private TestIdentifier(UniqueId uniqueId, String displayName, TestSource source2, Set<TestTag> tags, TestDescriptor.Type type2, UniqueId parentId, String legacyReportingName) {
        Preconditions.notNull(type2, "TestDescriptor.Type must not be null");
        this.uniqueId = uniqueId;
        this.parentId = parentId;
        this.displayName = displayName;
        this.source = source2;
        this.tags = this.copyOf(tags);
        this.type = type2;
        this.legacyReportingName = legacyReportingName;
    }

    private Set<TestTag> copyOf(Set<TestTag> tags) {
        switch (tags.size()) {
            case 0: {
                return Collections.emptySet();
            }
            case 1: {
                return Collections.singleton(CollectionUtils.getOnlyElement(tags));
            }
        }
        return new LinkedHashSet<TestTag>(tags);
    }

    public String getUniqueId() {
        return this.uniqueId.toString();
    }

    @API(status=API.Status.STABLE, since="1.8")
    public UniqueId getUniqueIdObject() {
        return this.uniqueId;
    }

    public Optional<String> getParentId() {
        return this.getParentIdObject().map(UniqueId::toString);
    }

    @API(status=API.Status.STABLE, since="1.8")
    public Optional<UniqueId> getParentIdObject() {
        return Optional.ofNullable(this.parentId);
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getLegacyReportingName() {
        return this.legacyReportingName;
    }

    public TestDescriptor.Type getType() {
        return this.type;
    }

    public boolean isTest() {
        return this.getType().isTest();
    }

    public boolean isContainer() {
        return this.getType().isContainer();
    }

    public Optional<TestSource> getSource() {
        return Optional.ofNullable(this.source);
    }

    public Set<TestTag> getTags() {
        return Collections.unmodifiableSet(this.tags);
    }

    public boolean equals(Object obj) {
        if (obj instanceof TestIdentifier) {
            TestIdentifier that = (TestIdentifier)obj;
            return Objects.equals(this.uniqueId, that.uniqueId);
        }
        return false;
    }

    public int hashCode() {
        return this.uniqueId.hashCode();
    }

    public String toString() {
        return new ToStringBuilder(this).append("uniqueId", this.uniqueId).append("parentId", this.parentId).append("displayName", this.displayName).append("legacyReportingName", this.legacyReportingName).append("source", this.source).append("tags", this.tags).append("type", (Object)this.type).toString();
    }

    private void writeObject(ObjectOutputStream s2) throws IOException {
        SerializedForm serializedForm = new SerializedForm(this);
        serializedForm.serialize(s2);
    }

    private void readObject(ObjectInputStream s2) throws ClassNotFoundException, IOException {
        SerializedForm serializedForm = SerializedForm.deserialize(s2);
        this.uniqueId = UniqueId.parse(serializedForm.uniqueId);
        this.displayName = serializedForm.displayName;
        this.source = serializedForm.source;
        this.tags = serializedForm.tags;
        this.type = serializedForm.type;
        String parentId = serializedForm.parentId;
        this.parentId = parentId == null ? null : UniqueId.parse(parentId);
        this.legacyReportingName = serializedForm.legacyReportingName;
    }

    private static class SerializedForm
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final String uniqueId;
        private final String parentId;
        private final String displayName;
        private final String legacyReportingName;
        private final TestSource source;
        private final Set<TestTag> tags;
        private final TestDescriptor.Type type;

        SerializedForm(TestIdentifier testIdentifier) {
            this.uniqueId = testIdentifier.uniqueId.toString();
            UniqueId parentId = testIdentifier.parentId;
            this.parentId = parentId == null ? null : parentId.toString();
            this.displayName = testIdentifier.displayName;
            this.legacyReportingName = testIdentifier.legacyReportingName;
            this.source = testIdentifier.source;
            this.tags = testIdentifier.tags;
            this.type = testIdentifier.type;
        }

        private SerializedForm(ObjectInputStream.GetField fields2) throws IOException {
            this.uniqueId = (String)fields2.get("uniqueId", null);
            this.parentId = (String)fields2.get("parentId", null);
            this.displayName = (String)fields2.get("displayName", null);
            this.legacyReportingName = (String)fields2.get("legacyReportingName", null);
            this.source = (TestSource)fields2.get("source", null);
            this.tags = (Set)fields2.get("tags", null);
            this.type = (TestDescriptor.Type)((Object)fields2.get("type", null));
        }

        void serialize(ObjectOutputStream s2) throws IOException {
            ObjectOutputStream.PutField fields2 = s2.putFields();
            fields2.put("uniqueId", this.uniqueId);
            fields2.put("parentId", this.parentId);
            fields2.put("displayName", this.displayName);
            fields2.put("legacyReportingName", this.legacyReportingName);
            fields2.put("source", this.source);
            fields2.put("tags", this.tags);
            fields2.put("type", (Object)this.type);
            s2.writeFields();
        }

        static SerializedForm deserialize(ObjectInputStream s2) throws ClassNotFoundException, IOException {
            ObjectInputStream.GetField fields2 = s2.readFields();
            return new SerializedForm(fields2);
        }
    }
}

