/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.Optional;
import org.junit.platform.commons.JUnitException;
import org.junit.platform.launcher.LauncherInterceptor;
import org.junit.platform.launcher.core.ClasspathAlignmentChecker;

class ClasspathAlignmentCheckingLauncherInterceptor
implements LauncherInterceptor {
    static final LauncherInterceptor INSTANCE = new ClasspathAlignmentCheckingLauncherInterceptor();

    ClasspathAlignmentCheckingLauncherInterceptor() {
    }

    @Override
    public <T> T intercept(LauncherInterceptor.Invocation<T> invocation) {
        try {
            return invocation.proceed();
        }
        catch (LinkageError e2) {
            Optional<JUnitException> exception = ClasspathAlignmentChecker.check(e2);
            if (exception.isPresent()) {
                throw exception.get();
            }
            throw e2;
        }
    }

    @Override
    public void close() {
    }
}

