/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.UniqueId;

class EngineDiscoveryResultValidator {
    EngineDiscoveryResultValidator() {
    }

    void validate(TestEngine testEngine, TestDescriptor root) {
        Preconditions.notNull(root, () -> String.format("The discover() method for TestEngine with ID '%s' must return a non-null root TestDescriptor.", testEngine.getId()));
        Optional<String> cyclicGraphInfo = this.getCyclicGraphInfo(root);
        Preconditions.condition(!cyclicGraphInfo.isPresent(), () -> String.format("The discover() method for TestEngine with ID '%s' returned a cyclic graph; %s", testEngine.getId(), cyclicGraphInfo.get()));
    }

    private Optional<String> getCyclicGraphInfo(TestDescriptor root) {
        HashMap<UniqueId, Optional<UniqueId>> visited = new HashMap<UniqueId, Optional<UniqueId>>();
        visited.put(root.getUniqueId(), Optional.empty());
        ArrayDeque<TestDescriptor> queue = new ArrayDeque<TestDescriptor>();
        queue.add(root);
        while (!queue.isEmpty()) {
            TestDescriptor parent = (TestDescriptor)queue.remove();
            for (TestDescriptor testDescriptor : parent.getChildren()) {
                UniqueId uid = testDescriptor.getUniqueId();
                if (visited.containsKey(uid)) {
                    List<UniqueId> path1 = EngineDiscoveryResultValidator.findPath(visited, uid);
                    List<UniqueId> path2 = EngineDiscoveryResultValidator.findPath(visited, parent.getUniqueId());
                    path2.add(uid);
                    return Optional.of(String.format("%s exists in at least two paths:\n(1) %s\n(2) %s", uid, this.formatted(path1), this.formatted(path2)));
                }
                visited.put(uid, Optional.of(parent.getUniqueId()));
                if (!testDescriptor.isContainer()) continue;
                queue.add(testDescriptor);
            }
        }
        return Optional.empty();
    }

    private String formatted(List<UniqueId> path2) {
        return path2.stream().map(UniqueId::toString).collect(Collectors.joining(" -> "));
    }

    private static List<UniqueId> findPath(Map<UniqueId, Optional<UniqueId>> visited, UniqueId target) {
        Optional<UniqueId> backTraced;
        ArrayList<UniqueId> path2 = new ArrayList<UniqueId>();
        path2.add(target);
        UniqueId current = target;
        while (visited.containsKey(current) && (backTraced = visited.get(current)).isPresent()) {
            path2.add(0, backTraced.get());
            current = backTraced.get();
        }
        return path2;
    }
}

