/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.CollectionUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ToStringBuilder;
import org.junit.platform.engine.ConfigurationParameters;

class LauncherConfigurationParameters
implements ConfigurationParameters {
    private static final Logger logger = LoggerFactory.getLogger(LauncherConfigurationParameters.class);
    private final List<ParameterProvider> providers;

    static Builder builder() {
        return new Builder();
    }

    private LauncherConfigurationParameters(List<ParameterProvider> providers) {
        this.providers = providers;
    }

    @Override
    public Optional<String> get(String key2) {
        return Optional.ofNullable(this.getProperty(key2));
    }

    @Override
    public Optional<Boolean> getBoolean(String key2) {
        return this.get(key2).map(Boolean::parseBoolean);
    }

    @Override
    public int size() {
        return this.providers.stream().mapToInt(ParameterProvider::size).sum();
    }

    @Override
    public Set<String> keySet() {
        return this.providers.stream().map(ParameterProvider::keySet).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private String getProperty(String key2) {
        Preconditions.notBlank(key2, "key must not be null or blank");
        return this.providers.stream().map(parameterProvider -> parameterProvider.getValue(key2)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public String toString() {
        return new ToStringBuilder(this).append("lookups", this.providers).toString();
    }

    private static Properties loadClasspathResource(String configFileName) {
        Properties props;
        block9: {
            props = new Properties();
            try {
                ClassLoader classLoader = ClassLoaderUtils.getDefaultClassLoader();
                LinkedHashSet<URL> resources2 = new LinkedHashSet<URL>(Collections.list(classLoader.getResources(configFileName)));
                if (resources2.isEmpty()) break block9;
                URL configFileUrl = CollectionUtils.getFirstElement(resources2).get();
                if (resources2.size() > 1) {
                    logger.warn(() -> {
                        String formattedResourceList = Stream.concat(Stream.of(configFileUrl + " (*)"), resources2.stream().skip(1L).map(URL::toString)).collect(Collectors.joining("\n- ", "\n- ", ""));
                        return String.format("Discovered %d '%s' configuration files on the classpath (see below); only the first (*) will be used.%s", resources2.size(), configFileName, formattedResourceList);
                    });
                }
                logger.config(() -> String.format("Loading JUnit Platform configuration parameters from classpath resource [%s].", configFileUrl));
                URLConnection urlConnection = configFileUrl.openConnection();
                urlConnection.setUseCaches(false);
                try (InputStream inputStream2 = urlConnection.getInputStream();){
                    props.load(inputStream2);
                }
            }
            catch (Exception ex) {
                logger.warn(ex, () -> String.format("Failed to load JUnit Platform configuration parameters from classpath resource [%s].", configFileName));
            }
        }
        return props;
    }

    static final class Builder {
        private final Map<String, String> explicitParameters = new HashMap<String, String>();
        private final List<String> configResources = new ArrayList<String>();
        private boolean implicitProvidersEnabled = true;
        private String configFileName = "junit-platform.properties";
        private ConfigurationParameters parentConfigurationParameters;

        private Builder() {
        }

        Builder explicitParameters(Map<String, String> parameters2) {
            Preconditions.notNull(parameters2, "configuration parameters must not be null");
            this.explicitParameters.putAll(parameters2);
            return this;
        }

        Builder configurationResources(List<String> configResources) {
            Preconditions.notNull(configResources, "configResources must not be null");
            this.configResources.addAll(configResources);
            return this;
        }

        Builder enableImplicitProviders(boolean enabled) {
            this.implicitProvidersEnabled = enabled;
            return this;
        }

        Builder configFileName(String configFileName) {
            Preconditions.notBlank(configFileName, "configFileName must not be null or blank");
            this.configFileName = configFileName;
            return this;
        }

        Builder parentConfigurationParameters(ConfigurationParameters parameters2) {
            Preconditions.notNull(parameters2, "parent configuration parameters must not be null");
            this.parentConfigurationParameters = parameters2;
            return this;
        }

        LauncherConfigurationParameters build() {
            ArrayList<ParameterProvider> parameterProviders = new ArrayList<ParameterProvider>();
            if (!this.explicitParameters.isEmpty()) {
                parameterProviders.add(ParameterProvider.explicit(this.explicitParameters));
            }
            CollectionUtils.forEachInReverseOrder(this.configResources, configResource -> parameterProviders.add(ParameterProvider.propertiesFile(configResource)));
            if (this.parentConfigurationParameters != null) {
                parameterProviders.add(ParameterProvider.inherited(this.parentConfigurationParameters));
            }
            if (this.implicitProvidersEnabled) {
                parameterProviders.add(ParameterProvider.systemProperties());
                parameterProviders.add(ParameterProvider.propertiesFile(this.configFileName));
            }
            return new LauncherConfigurationParameters(parameterProviders);
        }
    }

    private static interface ParameterProvider {
        public String getValue(String var1);

        default public int size() {
            return 0;
        }

        public Set<String> keySet();

        public static ParameterProvider explicit(final Map<String, String> configParams) {
            return new ParameterProvider(){

                @Override
                public String getValue(String key2) {
                    return (String)configParams.get(key2);
                }

                @Override
                public int size() {
                    return configParams.size();
                }

                @Override
                public Set<String> keySet() {
                    return configParams.keySet();
                }

                public String toString() {
                    ToStringBuilder builder = new ToStringBuilder("explicit");
                    configParams.forEach(builder::append);
                    return builder.toString();
                }
            };
        }

        public static ParameterProvider systemProperties() {
            return new ParameterProvider(){

                @Override
                public String getValue(String key2) {
                    try {
                        return System.getProperty(key2);
                    }
                    catch (Exception ignore) {
                        return null;
                    }
                }

                @Override
                public Set<String> keySet() {
                    return System.getProperties().stringPropertyNames();
                }

                public String toString() {
                    return "systemProperties [...]";
                }
            };
        }

        public static ParameterProvider propertiesFile(String configFileName) {
            Preconditions.notBlank(configFileName, "configFileName must not be null or blank");
            final Properties properties = LauncherConfigurationParameters.loadClasspathResource(configFileName.trim());
            return new ParameterProvider(){

                @Override
                public String getValue(String key2) {
                    return properties.getProperty(key2);
                }

                @Override
                public Set<String> keySet() {
                    return properties.stringPropertyNames();
                }

                public String toString() {
                    ToStringBuilder builder = new ToStringBuilder("propertiesFile");
                    properties.stringPropertyNames().forEach(key2 -> builder.append((String)key2, this.getValue((String)key2)));
                    return builder.toString();
                }
            };
        }

        public static ParameterProvider inherited(final ConfigurationParameters configParams) {
            return new ParameterProvider(){

                @Override
                public String getValue(String key2) {
                    return configParams.get(key2).orElse(null);
                }

                @Override
                public int size() {
                    return configParams.size();
                }

                @Override
                public Set<String> keySet() {
                    return configParams.keySet();
                }

                public String toString() {
                    ToStringBuilder builder = new ToStringBuilder("inherited");
                    builder.append("parent", configParams);
                    return builder.toString();
                }
            };
        }
    }
}

