/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.DiscoveryIssue;
import org.junit.platform.engine.TestDescriptor;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.reporting.OutputDirectoryProvider;
import org.junit.platform.launcher.core.DiscoveryIssueNotifier;

@API(status=API.Status.INTERNAL, since="1.7", consumers={"org.junit.platform.testkit", "org.junit.platform.suite.engine"})
public class LauncherDiscoveryResult {
    private final Map<TestEngine, EngineResultInfo> testEngineResults;
    private final ConfigurationParameters configurationParameters;
    private final OutputDirectoryProvider outputDirectoryProvider;

    LauncherDiscoveryResult(Map<TestEngine, EngineResultInfo> testEngineResults, ConfigurationParameters configurationParameters, OutputDirectoryProvider outputDirectoryProvider) {
        this.testEngineResults = Collections.unmodifiableMap(new LinkedHashMap<TestEngine, EngineResultInfo>(testEngineResults));
        this.configurationParameters = configurationParameters;
        this.outputDirectoryProvider = outputDirectoryProvider;
    }

    public TestDescriptor getEngineTestDescriptor(TestEngine testEngine) {
        return this.getEngineResult(testEngine).getRootDescriptor();
    }

    @API(status=API.Status.INTERNAL, since="1.13")
    public List<DiscoveryIssue> getDiscoveryIssues(TestEngine testEngine) {
        return this.getEngineResult(testEngine).getDiscoveryIssueNotifier().getAllIssues();
    }

    EngineResultInfo getEngineResult(TestEngine testEngine) {
        return this.testEngineResults.get(testEngine);
    }

    ConfigurationParameters getConfigurationParameters() {
        return this.configurationParameters;
    }

    OutputDirectoryProvider getOutputDirectoryProvider() {
        return this.outputDirectoryProvider;
    }

    public Collection<TestEngine> getTestEngines() {
        return this.testEngineResults.keySet();
    }

    boolean containsCriticalIssuesOrContainsTests() {
        return this.testEngineResults.values().stream().anyMatch(EngineResultInfo::containsCriticalIssuesOrContainsTests);
    }

    Collection<TestDescriptor> getEngineTestDescriptors() {
        return this.testEngineResults.values().stream().map(EngineResultInfo::getRootDescriptor).collect(Collectors.toList());
    }

    public LauncherDiscoveryResult withRetainedEngines(Predicate<? super TestDescriptor> predicate) {
        Map<TestEngine, EngineResultInfo> prunedTestEngineResults = this.retainEngines(predicate);
        if (prunedTestEngineResults.size() < this.testEngineResults.size()) {
            return new LauncherDiscoveryResult(prunedTestEngineResults, this.configurationParameters, this.outputDirectoryProvider);
        }
        return this;
    }

    private Map<TestEngine, EngineResultInfo> retainEngines(Predicate<? super TestDescriptor> predicate) {
        return this.testEngineResults.entrySet().stream().filter(entry -> predicate.test(((EngineResultInfo)entry.getValue()).getRootDescriptor())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    static class EngineResultInfo {
        private final TestDescriptor rootDescriptor;
        private final Throwable cause;
        private final DiscoveryIssueNotifier discoveryIssueNotifier;

        static EngineResultInfo completed(TestDescriptor rootDescriptor, DiscoveryIssueNotifier discoveryIssueNotifier) {
            return new EngineResultInfo(rootDescriptor, discoveryIssueNotifier, null);
        }

        static EngineResultInfo errored(TestDescriptor rootDescriptor, DiscoveryIssueNotifier discoveryIssueNotifier, Throwable cause) {
            return new EngineResultInfo(rootDescriptor, discoveryIssueNotifier, cause);
        }

        EngineResultInfo(TestDescriptor rootDescriptor, DiscoveryIssueNotifier discoveryIssueNotifier, Throwable cause) {
            this.rootDescriptor = rootDescriptor;
            this.discoveryIssueNotifier = discoveryIssueNotifier;
            this.cause = cause;
        }

        TestDescriptor getRootDescriptor() {
            return this.rootDescriptor;
        }

        DiscoveryIssueNotifier getDiscoveryIssueNotifier() {
            return this.discoveryIssueNotifier;
        }

        Optional<Throwable> getCause() {
            return Optional.ofNullable(this.cause);
        }

        boolean containsCriticalIssuesOrContainsTests() {
            return this.cause != null || this.discoveryIssueNotifier.hasCriticalIssues() || TestDescriptor.containsTests(this.rootDescriptor);
        }
    }
}

