/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.launcher.core;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.apiguardian.api.API;
import org.junit.platform.commons.PreconditionViolationException;
import org.junit.platform.commons.util.ClassNamePatternFilterUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.engine.ConfigurationParameters;
import org.junit.platform.engine.TestEngine;
import org.junit.platform.engine.support.store.Namespace;
import org.junit.platform.engine.support.store.NamespacedHierarchicalStore;
import org.junit.platform.launcher.Launcher;
import org.junit.platform.launcher.LauncherDiscoveryListener;
import org.junit.platform.launcher.LauncherInterceptor;
import org.junit.platform.launcher.LauncherSession;
import org.junit.platform.launcher.LauncherSessionListener;
import org.junit.platform.launcher.PostDiscoveryFilter;
import org.junit.platform.launcher.TestExecutionListener;
import org.junit.platform.launcher.core.ClasspathAlignmentCheckingLauncherInterceptor;
import org.junit.platform.launcher.core.DefaultLauncher;
import org.junit.platform.launcher.core.DefaultLauncherSession;
import org.junit.platform.launcher.core.LauncherConfig;
import org.junit.platform.launcher.core.LauncherConfigurationParameters;
import org.junit.platform.launcher.core.ListenerRegistry;
import org.junit.platform.launcher.core.ServiceLoaderRegistry;
import org.junit.platform.launcher.core.ServiceLoaderTestEngineRegistry;
import org.junit.platform.launcher.core.SessionPerRequestLauncher;

@API(status=API.Status.STABLE, since="1.0")
public class LauncherFactory {
    private LauncherFactory() {
    }

    @API(status=API.Status.STABLE, since="1.10")
    public static LauncherSession openSession() throws PreconditionViolationException {
        return LauncherFactory.openSession(LauncherConfig.DEFAULT);
    }

    @API(status=API.Status.STABLE, since="1.10")
    public static LauncherSession openSession(LauncherConfig config2) throws PreconditionViolationException {
        Preconditions.notNull(config2, "LauncherConfig must not be null");
        LauncherConfigurationParameters configurationParameters = LauncherConfigurationParameters.builder().build();
        return new DefaultLauncherSession(LauncherFactory.collectLauncherInterceptors(configurationParameters), () -> LauncherFactory.createLauncherSessionListener(config2), sessionLevelStore -> LauncherFactory.createDefaultLauncher(config2, configurationParameters, sessionLevelStore));
    }

    public static Launcher create() throws PreconditionViolationException {
        return LauncherFactory.create(LauncherConfig.DEFAULT);
    }

    @API(status=API.Status.STABLE, since="1.10")
    public static Launcher create(LauncherConfig config2) throws PreconditionViolationException {
        Preconditions.notNull(config2, "LauncherConfig must not be null");
        LauncherConfigurationParameters configurationParameters = LauncherConfigurationParameters.builder().build();
        return new SessionPerRequestLauncher(sessionLevelStore -> LauncherFactory.createDefaultLauncher(config2, configurationParameters, sessionLevelStore), () -> LauncherFactory.createLauncherSessionListener(config2), () -> LauncherFactory.collectLauncherInterceptors(configurationParameters));
    }

    private static DefaultLauncher createDefaultLauncher(LauncherConfig config2, LauncherConfigurationParameters configurationParameters, NamespacedHierarchicalStore<Namespace> sessionLevelStore) {
        Set<TestEngine> engines = LauncherFactory.collectTestEngines(config2);
        List<PostDiscoveryFilter> filters = LauncherFactory.collectPostDiscoveryFilters(config2);
        DefaultLauncher launcher = new DefaultLauncher(engines, filters, sessionLevelStore);
        LauncherFactory.registerLauncherDiscoveryListeners(config2, launcher);
        LauncherFactory.registerTestExecutionListeners(config2, launcher, configurationParameters);
        return launcher;
    }

    private static List<LauncherInterceptor> collectLauncherInterceptors(LauncherConfigurationParameters configurationParameters) {
        ArrayList<LauncherInterceptor> interceptors = new ArrayList<LauncherInterceptor>();
        if (configurationParameters.getBoolean("junit.platform.launcher.interceptors.enabled").orElse(false).booleanValue()) {
            ServiceLoaderRegistry.load(LauncherInterceptor.class).forEach(interceptors::add);
        }
        interceptors.add(ClasspathAlignmentCheckingLauncherInterceptor.INSTANCE);
        return interceptors;
    }

    private static Set<TestEngine> collectTestEngines(LauncherConfig config2) {
        LinkedHashSet<TestEngine> engines = new LinkedHashSet<TestEngine>();
        if (config2.isTestEngineAutoRegistrationEnabled()) {
            new ServiceLoaderTestEngineRegistry().loadTestEngines().forEach(engines::add);
        }
        engines.addAll(config2.getAdditionalTestEngines());
        return engines;
    }

    private static LauncherSessionListener createLauncherSessionListener(LauncherConfig config2) {
        ListenerRegistry<LauncherSessionListener> listenerRegistry = ListenerRegistry.forLauncherSessionListeners();
        if (config2.isLauncherSessionListenerAutoRegistrationEnabled()) {
            ServiceLoaderRegistry.load(LauncherSessionListener.class).forEach(listenerRegistry::add);
        }
        config2.getAdditionalLauncherSessionListeners().forEach(listenerRegistry::add);
        return listenerRegistry.getCompositeListener();
    }

    private static List<PostDiscoveryFilter> collectPostDiscoveryFilters(LauncherConfig config2) {
        ArrayList<PostDiscoveryFilter> filters = new ArrayList<PostDiscoveryFilter>();
        if (config2.isPostDiscoveryFilterAutoRegistrationEnabled()) {
            ServiceLoaderRegistry.load(PostDiscoveryFilter.class).forEach(filters::add);
        }
        filters.addAll(config2.getAdditionalPostDiscoveryFilters());
        return filters;
    }

    private static void registerLauncherDiscoveryListeners(LauncherConfig config2, Launcher launcher) {
        if (config2.isLauncherDiscoveryListenerAutoRegistrationEnabled()) {
            ServiceLoaderRegistry.load(LauncherDiscoveryListener.class).forEach(xva$0 -> launcher.registerLauncherDiscoveryListeners((LauncherDiscoveryListener)xva$0));
        }
        config2.getAdditionalLauncherDiscoveryListeners().forEach(xva$0 -> launcher.registerLauncherDiscoveryListeners((LauncherDiscoveryListener)xva$0));
    }

    private static void registerTestExecutionListeners(LauncherConfig config2, Launcher launcher, LauncherConfigurationParameters configurationParameters) {
        if (config2.isTestExecutionListenerAutoRegistrationEnabled()) {
            LauncherFactory.loadAndFilterTestExecutionListeners(configurationParameters).forEach(xva$0 -> launcher.registerTestExecutionListeners((TestExecutionListener)xva$0));
        }
        config2.getAdditionalTestExecutionListeners().forEach(xva$0 -> launcher.registerTestExecutionListeners((TestExecutionListener)xva$0));
    }

    private static Iterable<TestExecutionListener> loadAndFilterTestExecutionListeners(ConfigurationParameters configurationParameters) {
        Predicate<String> classNameFilter = configurationParameters.get("junit.platform.execution.listeners.deactivate").map(ClassNamePatternFilterUtils::excludeMatchingClassNames).orElse(__ -> true);
        return ServiceLoaderRegistry.load(TestExecutionListener.class, classNameFilter);
    }
}

